/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.distillery.window;

import binnie.core.api.gui.Alignment;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlEnergyBar;
import binnie.core.gui.minecraft.control.ControlErrorState;
import binnie.core.gui.minecraft.control.ControlLiquidTank;
import binnie.core.gui.minecraft.control.ControlPlayerInventory;
import binnie.core.machines.Machine;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.machines.distillery.DistilleryLogic;
import binnie.extratrees.machines.distillery.window.ControlDistilleryProgress;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowDistillery
extends Window {
    public WindowDistillery(EntityPlayer player, IInventory inventory, Side side) {
        super(224, 192, player, inventory, side);
    }

    @Nullable
    public static Window create(EntityPlayer player, @Nullable IInventory inventory, Side side) {
        if (inventory == null) {
            return null;
        }
        return new WindowDistillery(player, inventory, side);
    }

    @Override
    protected String getModId() {
        return ExtraTrees.instance.getModId();
    }

    @Override
    protected String getBackgroundTextureName() {
        return "Distillery";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setTitle(Machine.getMachine(this.getInventory()).getPackage().getDisplayName());
        int x = 16;
        new ControlLiquidTank(this, x, 35).setTankID(0);
        new ControlDistilleryProgress(this, x += 34, 32);
        new ControlLiquidTank(this, x += 64, 35).setTankID(1);
        new ControlEnergyBar(this, x += 34, 36, 60, 16, Alignment.LEFT);
        new ControlPlayerInventory(this);
        new ControlErrorState(this, x + 21, 62);
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
        DistilleryLogic distilleryLogic;
        if ("still-level".equals(name) && (distilleryLogic = Machine.getInterface(DistilleryLogic.class, ((Window)Window.get(this)).getInventory())) != null) {
            distilleryLogic.setLevel(nbt.func_74771_c("i"));
        }
    }
}

