/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.circuit;

import binnie.extrabees.circuit.AlvearySimulatorCircuitType;
import com.google.common.collect.Lists;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.PluginCore;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class StimulatorCircuit
implements ICircuit,
IBeeModifier {
    private final AlvearySimulatorCircuitType type;
    private final String uid;
    private final List<String> tooltip;

    public StimulatorCircuit(AlvearySimulatorCircuitType type, ICircuitLayout layout) {
        this.uid = "binnie.circuit.stimulator." + type.toString().toLowerCase();
        this.type = type;
        ItemStack stack = new ItemStack((Item)PluginCore.getItems().tubes, 1, type.getRecipe());
        ChipsetManager.circuitRegistry.registerCircuit((ICircuit)this);
        ChipsetManager.solderManager.addRecipe(layout, stack, (ICircuit)this);
        this.tooltip = Lists.newArrayList();
    }

    public int getPowerUsage() {
        return this.type.getPower();
    }

    public void addTooltip(String tt) {
        this.tooltip.add(tt);
    }

    public float getTerritoryModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.type.getTerritoryModifier(genome, currentModifier);
    }

    public float getMutationModifier(@Nonnull IBeeGenome genome, @Nonnull IBeeGenome mate, float currentModifier) {
        return this.type.getMutationModifier(genome, mate, currentModifier);
    }

    public float getLifespanModifier(@Nonnull IBeeGenome genome, @Nullable IBeeGenome mate, float currentModifier) {
        return this.type.getLifespanModifier(genome, mate, currentModifier);
    }

    public float getProductionModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.type.getProductionModifier(genome, currentModifier);
    }

    public float getFloweringModifier(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.type.getFloweringModifier(genome, currentModifier);
    }

    public boolean isSealed() {
        return this.type.isSealed();
    }

    public boolean isSelfLighted() {
        return this.type.isSelfLighted();
    }

    public boolean isSunlightSimulated() {
        return this.type.isSunlightSimulated();
    }

    public boolean isHellish() {
        return this.type.isHellish();
    }

    public float getGeneticDecay(@Nonnull IBeeGenome genome, float currentModifier) {
        return this.type.getGeneticDecay(genome, currentModifier);
    }

    @Nonnull
    public String getUID() {
        return this.uid;
    }

    @Nonnull
    public String getUnlocalizedName() {
        return this.uid;
    }

    public boolean isCircuitable(@Nonnull Object tile) {
        System.out.println("isCircuitable: " + tile);
        return false;
    }

    public void onInsertion(int slot, @Nonnull Object tile) {
    }

    public void onLoad(int slot, @Nonnull Object tile) {
    }

    public void onRemoval(int slot, @Nonnull Object tile) {
    }

    public void onTick(int slot, @Nonnull Object tile) {
    }

    public void addTooltip(@Nonnull List<String> list) {
        list.addAll(this.tooltip);
    }
}

