/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.splicer;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IRender;
import binnie.core.machines.network.INetwork;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SplicerFX
extends MachineComponent
implements IRender.DisplayTick,
IRender.Render,
INetwork.TilePacketSync {
    private final EntityItem dummyEntityItem;

    public SplicerFX(IMachine machine) {
        super(machine);
        this.dummyEntityItem = new EntityItem(machine.getWorld());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDisplayTick(World world, BlockPos pos, Random rand) {
        int tick = (int)(world.func_82737_E() % 3L);
        if (tick == 0 && this.getUtil().getProcess().isInProgress()) {
            ParticleManager effectRenderer = BinnieCore.getBinnieProxy().getMinecraftInstance().field_71452_i;
            effectRenderer.func_78873_a((Particle)new SplicerParticle(world, pos));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInWorld(double x, double y, double z) {
        if (!this.getUtil().getProcess().isInProgress()) {
            return;
        }
        ItemStack stack = this.getUtil().getStack(9);
        this.dummyEntityItem.field_70170_p = this.getMachine().getWorld();
        this.dummyEntityItem.func_92058_a(stack);
        EntityItem dummyEntityItem = this.dummyEntityItem;
        dummyEntityItem.func_70288_d();
        this.dummyEntityItem.field_70290_d = 0.0f;
        if (stack.func_190926_b()) {
            return;
        }
        EntityPlayer player = BinnieCore.getBinnieProxy().getPlayer();
        double dx = x + 0.5 - player.field_70142_S;
        double dz = z + 0.5 - player.field_70136_U;
        double t = Math.atan2(dz, dx) * 180.0 / 3.1415;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
        BinnieCore.getBinnieProxy().getMinecraftInstance().func_175599_af().func_181564_a(dummyEntityItem.func_92059_d(), ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
    }

    @Override
    public void syncToNBT(NBTTagCompound nbt) {
        NBTTagCompound item = new NBTTagCompound();
        ItemStack stack = this.getUtil().getStack(9);
        if (!stack.func_190926_b()) {
            stack.func_77955_b(item);
            nbt.func_74782_a("item", (NBTBase)item);
        }
    }

    @Override
    public void syncFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("item")) {
            this.getUtil().setStack(9, new ItemStack(nbt.func_74775_l("item")));
        } else {
            this.getUtil().setStack(9, ItemStack.field_190927_a);
        }
    }

    @Override
    public void onInventoryUpdate() {
        if (!this.getUtil().isServer()) {
            return;
        }
        this.getUtil().refreshBlock();
    }

    private static class SplicerParticle
    extends Particle {
        private double axisX;
        private double axisZ;
        private double angle;

        public SplicerParticle(World world, BlockPos pos) {
            super(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            this.axisX = this.field_187126_f;
            this.axisZ = this.field_187128_h;
            this.angle = (double)((int)(this.field_187122_b.func_82737_E() % 4L)) * 0.5 * 3.1415;
            this.axisX = 0.0;
            this.axisZ = 0.0;
            this.angle = 0.0;
            this.field_187129_i = 0.0;
            this.field_187131_k = 0.0;
            this.field_187130_j = (this.field_187136_p.nextDouble() - 0.5) * 0.02;
            this.field_70547_e = 240;
            this.field_70545_g = 0.0f;
            this.field_190017_n = true;
            this.func_70538_b(0.3f + this.field_187136_p.nextFloat() * 0.5f, 0.3f + this.field_187136_p.nextFloat() * 0.5f, 0.0f);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_189213_a() {
            super.func_189213_a();
            double speed = 0.04;
            this.angle -= 0.04;
            double dist = 0.25 + 0.2 * Math.sin((float)this.field_70546_d / 50.0f);
            this.func_187109_b(this.axisX + dist * Math.sin(this.angle), this.field_187127_g, this.axisZ + dist * Math.cos(this.angle));
            this.func_82338_g((float)Math.cos(1.57 * (double)this.field_70546_d / (double)this.field_70547_e));
        }

        public int func_70537_b() {
            return 0;
        }
    }
}

