/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.blocks.wood;

import binnie.extratrees.wood.EnumETLog;
import forestry.api.arboriculture.IWoodItemMeshDefinition;
import forestry.api.arboriculture.IWoodStateMapper;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.arboriculture.proxy.ProxyArboricultureClient;
import forestry.core.blocks.IColoredBlock;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockETDoor
extends BlockDoor
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister,
IColoredBlock {
    private final EnumETLog woodType;

    public BlockETDoor(EnumETLog woodType) {
        super(Material.field_151575_d);
        this.woodType = woodType;
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(Tabs.tabArboriculture);
        String name = "doors." + (Object)((Object)woodType);
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("extratrees", "door")});
        ProxyArboricultureClient.registerWoodMeshDefinition((Item)item, (IWoodItemMeshDefinition)new WoodMeshDefinition());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        ProxyArboricultureClient.registerWoodStateMapper((Block)this, (IWoodStateMapper)new WoodTypeStateMapper((IWoodTyped)this, null).addPropertyToRemove((IProperty)field_176522_N));
    }

    public WoodBlockKind getBlockKind() {
        return WoodBlockKind.DOOR;
    }

    public boolean isFireproof() {
        return false;
    }

    public EnumETLog getWoodType(int meta) {
        return this.woodType;
    }

    public Collection<EnumETLog> getWoodTypes() {
        return Collections.singleton(this.woodType);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        EnumETLog woodType = this.getWoodType(meta);
        return woodType.getHardness();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.func_176509_j();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.func_176509_j());
    }

    private Item func_176509_j() {
        return TreeManager.woodAccess.getStack((IWoodType)this.woodType, this.getBlockKind(), false).func_77973_b();
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        return this.woodType.getPlank().getColour();
    }

    @SideOnly(value=Side.CLIENT)
    public static class WoodMeshDefinition
    implements IWoodItemMeshDefinition {
        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return new ModelResourceLocation("extratrees:door", "inventory");
        }

        public ResourceLocation getDefaultModelLocation(ItemStack stack) {
            return new ResourceLocation("extratrees:item/door");
        }
    }
}

