/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.ceramic;

import binnie.botany.Botany;
import binnie.botany.api.genetics.EnumFlowerColor;
import binnie.botany.ceramic.CeramicColor;
import binnie.botany.items.CeramicItems;
import binnie.botany.modules.ModuleCeramic;
import binnie.design.Design;
import binnie.design.EnumPattern;
import binnie.design.api.IDesignMaterial;
import binnie.design.api.IDesignSystem;
import binnie.design.api.IPattern;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CeramicDesignSystem
implements IDesignSystem {
    public static final CeramicDesignSystem instance = new CeramicDesignSystem();
    private final Map<Integer, TextureAtlasSprite> primary = new HashMap<Integer, TextureAtlasSprite>();
    private final Map<Integer, TextureAtlasSprite> secondary = new HashMap<Integer, TextureAtlasSprite>();

    CeramicDesignSystem() {
        Design.getDesignManager().registerDesignSystem(this);
    }

    @Override
    public IDesignMaterial getDefaultMaterial() {
        return CeramicColor.get(EnumFlowerColor.White);
    }

    @Override
    public IDesignMaterial getDefaultMaterial2() {
        return CeramicColor.get(EnumFlowerColor.Black);
    }

    @Override
    public IDesignMaterial getMaterial(int id) {
        return CeramicColor.get(EnumFlowerColor.get(id));
    }

    @Override
    public int getMaterialIndex(IDesignMaterial id) {
        return ((CeramicColor)id).getMaterialIndex();
    }

    public String getTexturePath() {
        return "blocks/ceramic";
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getPrimarySprite(IPattern pattern) {
        int index = pattern.getIndex();
        if (index >= 0 && index < this.primary.size()) {
            return this.primary.get(index);
        }
        return null;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSecondarySprite(IPattern pattern) {
        int index = pattern.getIndex();
        if (index >= 0 && index < this.secondary.size()) {
            return this.secondary.get(index);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites() {
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        for (EnumPattern pattern : EnumPattern.values()) {
            ResourceLocation primaryLocation = new ResourceLocation(this.getModId(), this.getTexturePath() + "/" + pattern.toString().toLowerCase() + ".0");
            ResourceLocation secondaryLocation = new ResourceLocation(this.getModId(), this.getTexturePath() + "/" + pattern.toString().toLowerCase() + ".1");
            this.primary.put(pattern.getIndex(), textureMap.func_174942_a(primaryLocation));
            this.secondary.put(pattern.getIndex(), textureMap.func_174942_a(secondaryLocation));
        }
    }

    public String getModId() {
        return Botany.instance.getModId();
    }

    @Override
    public ItemStack getAdhesive() {
        return CeramicItems.MORTAR.get(1);
    }

    @Override
    @Nullable
    public IDesignMaterial getMaterial(ItemStack itemStack) {
        return itemStack.func_77973_b() == Item.func_150898_a((Block)ModuleCeramic.ceramic) ? this.getMaterial(itemStack.func_77952_i()) : null;
    }
}

