/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.models;

import forestry.api.core.IModelBaker;
import forestry.api.core.IModelBakerModel;
import forestry.core.models.ModelManager;
import forestry.core.models.baker.ModelBakerFace;
import forestry.core.models.baker.ModelBakerModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public class AABBModelBaker
implements IModelBaker {
    protected final FaceBakery faceBakery = new FaceBakery();
    private final List<BoundModelBakerFace> faces = new ArrayList<BoundModelBakerFace>();
    private final List<Pair<IBlockState, IBakedModel>> bakedModels = new ArrayList<Pair<IBlockState, IBakedModel>>();
    protected AxisAlignedBB modelBounds;
    protected final ModelBakerModel currentModel = new ModelBakerModel(ModelManager.getInstance().getDefaultBlockState());
    protected int colorIndex = -1;

    public AABBModelBaker() {
        this(Block.field_185505_j);
    }

    public AABBModelBaker(AxisAlignedBB modelBounds) {
        this.modelBounds = modelBounds;
    }

    public void setModelBounds(AxisAlignedBB modelBounds) {
        this.modelBounds = modelBounds;
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    public void addModel(TextureAtlasSprite[] textures, int colorIndex) {
        this.setColorIndex(colorIndex);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.addFace(facing, textures[facing.ordinal()]);
        }
    }

    public void addModel(TextureAtlasSprite texture, int colorIndex) {
        this.addModel(new TextureAtlasSprite[]{texture, texture, texture, texture, texture, texture}, colorIndex);
    }

    public void addBlockModel(@Nullable BlockPos pos, TextureAtlasSprite[] sprites, int colorIndex) {
        this.setColorIndex(colorIndex);
        if (pos != null) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            IBlockState blockState = world.func_180495_p(pos);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!blockState.func_185894_c((IBlockAccess)world, pos, facing)) continue;
                this.addFace(facing, sprites[facing.ordinal()]);
            }
        } else {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.addFace(facing, sprites[facing.ordinal()]);
            }
        }
    }

    public void addBlockModel(@Nullable BlockPos pos, TextureAtlasSprite sprite, int colorIndex) {
        this.addBlockModel(pos, new TextureAtlasSprite[]{sprite, sprite, sprite, sprite, sprite, sprite}, colorIndex);
    }

    public void addBakedModel(@Nullable IBlockState state, IBakedModel model) {
        if (model != null) {
            this.bakedModels.add((Pair<IBlockState, IBakedModel>)Pair.of((Object)state, (Object)model));
        }
    }

    protected float[] getFaceUvs(EnumFacing face, Vector3f to, Vector3f from) {
        float maxV;
        float maxU;
        float minV;
        float minU;
        switch (face) {
            case SOUTH: {
                minU = from.x;
                minV = from.y;
                maxU = to.x;
                maxV = to.y;
                break;
            }
            case NORTH: {
                minU = from.x;
                minV = from.y;
                maxU = to.x;
                maxV = to.y;
                break;
            }
            case WEST: {
                minU = from.z;
                minV = from.y;
                maxU = to.z;
                maxV = to.y;
                break;
            }
            case EAST: {
                minU = from.z;
                minV = from.y;
                maxU = to.z;
                maxV = to.y;
                break;
            }
            case UP: {
                minU = from.x;
                minV = from.z;
                maxU = to.x;
                maxV = to.z;
                break;
            }
            case DOWN: {
                minU = from.x;
                minV = from.z;
                maxU = to.x;
                maxV = to.z;
                break;
            }
            default: {
                minU = 0.0f;
                minV = 0.0f;
                maxU = 16.0f;
                maxV = 16.0f;
            }
        }
        if (minU < 0.0f || maxU > 16.0f) {
            minU = 0.0f;
            maxU = 16.0f;
        }
        if (minV < 0.0f || maxV > 16.0f) {
            minV = 0.0f;
            maxV = 16.0f;
        }
        minU = 16.0f - minU;
        minV = 16.0f - minV;
        maxU = 16.0f - maxU;
        maxV = 16.0f - maxV;
        return new float[]{minU, minV, maxU, maxV};
    }

    public void addFace(EnumFacing facing, TextureAtlasSprite sprite) {
        if (sprite == null) {
            return;
        }
        this.faces.add(new BoundModelBakerFace(facing, this.colorIndex, sprite, this.modelBounds));
    }

    public IModelBakerModel bakeModel(boolean flip) {
        ModelRotation mr = ModelRotation.X0_Y0;
        if (flip) {
            mr = ModelRotation.X0_Y180;
        }
        for (Pair<IBlockState, IBakedModel> bakedModel : this.bakedModels) {
            this.currentModel.addModelQuads(bakedModel);
        }
        for (BoundModelBakerFace face : this.faces) {
            AxisAlignedBB modelBounds = face.modelBounds;
            Vector3f from = new Vector3f((float)modelBounds.field_72340_a * 16.0f, (float)modelBounds.field_72338_b * 16.0f, (float)modelBounds.field_72339_c * 16.0f);
            Vector3f to = new Vector3f((float)modelBounds.field_72336_d * 16.0f, (float)modelBounds.field_72337_e * 16.0f, (float)modelBounds.field_72334_f * 16.0f);
            EnumFacing myFace = face.face;
            float[] uvs = this.getFaceUvs(myFace, to, from);
            BlockFaceUV uv = new BlockFaceUV(uvs, 0);
            BlockPartFace bpf = new BlockPartFace(myFace, face.colorIndex, "", uv);
            BakedQuad bf = this.faceBakery.func_178414_a(from, to, bpf, face.spite, myFace, mr, null, true, true);
            this.currentModel.addQuad(myFace, bf);
        }
        return this.currentModel;
    }

    public void setModelState(@Nullable IModelState modelState) {
        this.currentModel.setModelState(modelState);
    }

    public void setParticleSprite(TextureAtlasSprite particleSprite) {
        this.currentModel.setParticleSprite(particleSprite);
    }

    private static class BoundModelBakerFace
    extends ModelBakerFace {
        protected final AxisAlignedBB modelBounds;

        public BoundModelBakerFace(EnumFacing face, int colorIndex, TextureAtlasSprite sprite, AxisAlignedBB modelBounds) {
            super(face, colorIndex, sprite);
            this.modelBounds = modelBounds;
        }
    }
}

