/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.storage;

import binnie.core.machines.IMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.storage.CompartmentTab;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

class ComponentCompartmentInventory
extends ComponentInventorySlots
implements INetwork.GuiNBT {
    private final int tabCount;
    private final int slotsPerPage;
    private final Map<Integer, CompartmentTab> tabs = new HashMap<Integer, CompartmentTab>();

    public ComponentCompartmentInventory(IMachine machine, int tabCount, int pageSize) {
        super(machine);
        this.tabCount = tabCount;
        this.slotsPerPage = pageSize;
        for (int i = 0; i < this.tabCount * this.slotsPerPage; ++i) {
            this.addSlot(i, "compartment");
        }
    }

    public int getPageSize() {
        return this.slotsPerPage;
    }

    public int getTabCount() {
        return this.tabCount;
    }

    public int[] getSlotsForTab(int currentTab) {
        int[] slots = new int[this.slotsPerPage];
        for (int i = 0; i < this.slotsPerPage; ++i) {
            slots[i] = i + currentTab * this.slotsPerPage;
        }
        return slots;
    }

    public CompartmentTab getTab(int i) {
        return this.tabs.computeIfAbsent(i, CompartmentTab::new);
    }

    @Override
    public void sendGuiNBTToClient(Map<String, NBTTagCompound> nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.tabCount; ++i) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            this.getTab(i).writeToNBT(nbt2);
            list.func_74742_a((NBTBase)nbt2);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tabs", (NBTBase)list);
        nbt.put("comp-tabs", tag);
    }

    @Override
    public void receiveGuiNBTOnClient(EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("comp-tabs")) {
            NBTTagList tags = nbt.func_150295_c("tabs", 10);
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound tag = tags.func_150305_b(i);
                CompartmentTab tab = new CompartmentTab(tag);
                this.tabs.put(tab.getId(), tab);
            }
        }
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("comp-change-tab")) {
            CompartmentTab tab2 = new CompartmentTab(nbt);
            this.tabs.put(tab2.getId(), tab2);
            this.getMachine().getTileEntity().func_70296_d();
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTTagList tags = nbt.func_150295_c("tabs", 10);
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound tag = tags.func_150305_b(i);
            CompartmentTab tab = new CompartmentTab(tag);
            this.tabs.put(tab.getId(), tab);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt4) {
        NBTTagCompound nbt = super.writeToNBT(nbt4);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.tabCount; ++i) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            this.getTab(i).writeToNBT(nbt2);
            list.func_74742_a((NBTBase)nbt2);
        }
        nbt.func_74782_a("tabs", (NBTBase)list);
        return nbt;
    }
}

