/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.splicer;

import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.util.I18N;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.machine.AdvGeneticMachine;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.splicer.Splicer;
import binnie.genetics.machine.splicer.SplicerFX;
import binnie.genetics.machine.splicer.SplicerLogic;
import binnie.genetics.machine.splicer.ValidatorIndividualInoculate;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PackageSplicer
extends AdvGeneticMachine.PackageAdvGeneticBase
implements IMachineInformation {
    public PackageSplicer() {
        super("splicer", 14819893, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.SPLICER);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot slotSerumVial = inventory.addSlot(0, "serum.active");
        slotSerumVial.forbidInteraction();
        slotSerumVial.setReadOnly();
        SerumSlotValidator serumValid = new SerumSlotValidator();
        slotSerumVial.setValidator(serumValid);
        for (InventorySlot slot : inventory.addSlotArray(Splicer.SLOT_SERUM_RESERVE, "serum.input")) {
            slot.setValidator(serumValid);
            slot.forbidExtraction();
        }
        for (InventorySlot slot : inventory.addSlotArray(Splicer.SLOT_SERUM_EXPENDED, "serum.output")) {
            slot.setValidator(serumValid);
            slot.setReadOnly();
        }
        for (InventorySlot slot : inventory.addSlotArray(Splicer.SLOT_RESERVE, "input")) {
            slot.forbidExtraction();
            slot.setValidator(new ValidatorIndividualInoculate());
        }
        InventorySlot slotTarget = inventory.addSlot(9, "process");
        slotTarget.setValidator(new ValidatorIndividualInoculate());
        slotTarget.setReadOnly();
        slotTarget.forbidInteraction();
        for (InventorySlot slot : inventory.addSlotArray(Splicer.SLOT_FINISHED, "output")) {
            slot.setReadOnly();
            slot.forbidInsertion();
            slot.setValidator(new ValidatorIndividualInoculate());
        }
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Splicer.SLOT_RESERVE, 9, 1);
        transfer.addRestock(Splicer.SLOT_SERUM_RESERVE, 0);
        transfer.addStorage(0, Splicer.SLOT_SERUM_EXPENDED, stack -> Engineering.getCharges(stack) == 0);
        transfer.addStorage(9, Splicer.SLOT_FINISHED, stack -> {
            IMachine machine1;
            MachineUtil machineUtil;
            return !stack.func_190926_b() && !(machineUtil = (machine1 = transfer.getMachine()).getMachineUtil()).getStack(0).func_190926_b() && machine1.getInterface(SplicerLogic.class).isValidSerum() != null;
        });
        new ComponentPowerReceptor(machine, 20000);
        new SplicerLogic(machine);
        new SplicerFX(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }

    @Override
    public void register() {
    }

    private static class SerumSlotValidator
    extends SlotValidator {
        public SerumSlotValidator() {
            super(ModuleMachine.spriteSerum);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof IItemSerum;
        }

        @Override
        public String getTooltip() {
            return I18N.localise("genetics.machine.adv_machine.splicer.tooltips.slots.serum");
        }
    }
}

