/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.integration.jei.database;

import binnie.genetics.Genetics;
import binnie.genetics.integration.jei.GeneticsJeiPlugin;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DatabaseRecipeWrapper
implements IRecipeWrapper {
    private final ItemStack input;
    private final List<ItemStack> outputs;
    private final IDrawableAnimated arrowAnimated;

    public DatabaseRecipeWrapper(ItemStack input, List<ItemStack> outputs) {
        this.input = input;
        this.outputs = outputs;
        this.arrowAnimated = GeneticsJeiPlugin.drawables.createArrowAnimated(20);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        IDrawable arrow = GeneticsJeiPlugin.drawables.getArrow();
        arrow.draw(minecraft, 60, 4);
        this.arrowAnimated.draw(minecraft, 60, 4);
        String instructions = "Open the database and pick up an empty serum. Click the serum on a Sequenced gene to apply.";
        minecraft.field_71466_p.func_78279_b(instructions, 0, 40, recipeWidth, Color.gray.getRGB());
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, Arrays.asList(this.input, new ItemStack((Item)Genetics.items().database)));
        ingredients.setOutputLists(ItemStack.class, Collections.singletonList(this.outputs));
    }
}

