/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gui.database;

import binnie.core.Binnie;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.listbox.ControlList;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.database.ControlItemStackOption;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.IDatabaseMode;
import binnie.core.gui.database.PageBranchOverview;
import binnie.core.gui.database.PageBranchSpecies;
import binnie.core.gui.database.PageBreeder;
import binnie.core.gui.database.PageSpeciesClassification;
import binnie.core.gui.database.PageSpeciesMutations;
import binnie.core.gui.database.PageSpeciesOverview;
import binnie.core.gui.database.PageSpeciesResultant;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.minecraft.Window;
import binnie.core.util.I18N;
import binnie.design.api.IDesignMaterial;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.gui.database.PageFruit;
import binnie.extratrees.gui.database.PagePlanksOverview;
import binnie.extratrees.gui.database.PagePlanksTrees;
import binnie.extratrees.gui.database.PageSpeciesTreeGenome;
import binnie.extratrees.gui.database.PageWood;
import binnie.extratrees.wood.WoodManager;
import binnie.genetics.api.ITreeBreedingSystem;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.ISpeciesRoot;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowArboristDatabase
extends WindowAbstractDatabase {
    public WindowArboristDatabase(EntityPlayer player, Side side, boolean nei) {
        super(player, side, nei, Binnie.GENETICS.getSystem((ISpeciesRoot)TreeManager.treeRoot), 120);
    }

    public static Window create(EntityPlayer player, Side side, boolean nei) {
        return new WindowArboristDatabase(player, side, nei);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addTabs() {
        new PageSpeciesOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.overview"));
        new PageSpeciesTreeGenome((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.genome"));
        new PageSpeciesClassification((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.classification"));
        new PageSpeciesResultant((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.resultant"));
        new PageSpeciesMutations((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.further"));
        new PageBranchOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(ExtraTrees.instance, "branches.overview"));
        new PageBranchSpecies((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(ExtraTrees.instance, "branches.species"));
        new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.BREEDER), this.getUsername(), new DatabaseTab(ExtraTrees.instance, "breeder"));
        this.createMode(TreeMode.FRUIT, new FruitModeWidgets(this));
        this.createMode(TreeMode.WOOD, new WoodModeWidgets(this));
        this.createMode(TreeMode.PLANKS, new PlanksModeWidgets(this));
        new PageFruit(this.getInfoPages(TreeMode.FRUIT), new DatabaseTab(ExtraTrees.instance, "fruit.natural"), true);
        new PageFruit(this.getInfoPages(TreeMode.FRUIT), new DatabaseTab(ExtraTrees.instance, "fruit.potential"), false);
        new PageWood((IWidget)this.getInfoPages(TreeMode.WOOD), new DatabaseTab(ExtraTrees.instance, "wood.natural"));
        new PagePlanksOverview((IWidget)this.getInfoPages(TreeMode.PLANKS), new DatabaseTab(ExtraTrees.instance, "planks.overview"));
        new PagePlanksTrees((IWidget)this.getInfoPages(TreeMode.PLANKS), new DatabaseTab(ExtraTrees.instance, "planks.natural"));
    }

    @Override
    protected String getModId() {
        return ExtraTrees.instance.getModId();
    }

    @Override
    protected String getBackgroundTextureName() {
        return "TreeDatabase";
    }

    private static class PlanksModeWidgets
    extends WindowAbstractDatabase.ModeWidgets {
        public PlanksModeWidgets(WindowArboristDatabase windowArboristDatabase) {
            super(TreeMode.PLANKS, windowArboristDatabase);
        }

        @Override
        public void createListBox(IArea area) {
            PlanksModeControlListBox controlListBox = new PlanksModeControlListBox(this, area);
            controlListBox.setOptions(WoodManager.getAllPlankTypes().stream().map(IDesignMaterial::getStack).collect(Collectors.toList()));
            this.listBox = controlListBox;
        }

        private static class PlanksModeControlListBox
        extends ControlListBox<ItemStack> {
            public PlanksModeControlListBox(PlanksModeWidgets planksModeWidgets, IArea area) {
                super(planksModeWidgets.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public IWidget createOption(ItemStack value, int y) {
                return new ControlItemStackOption((ControlList)this.getContent(), value, y);
            }
        }
    }

    private static class WoodModeWidgets
    extends WindowAbstractDatabase.ModeWidgets {
        private WindowArboristDatabase windowArboristDatabase;

        public WoodModeWidgets(WindowArboristDatabase windowArboristDatabase) {
            super(TreeMode.WOOD, windowArboristDatabase);
            this.windowArboristDatabase = windowArboristDatabase;
        }

        @Override
        public void createListBox(IArea area) {
            WoodModeControlListBox controlListBox = new WoodModeControlListBox(this, area);
            ITreeBreedingSystem breedingSystem = (ITreeBreedingSystem)((Object)this.windowArboristDatabase.getBreedingSystem());
            controlListBox.setOptions(breedingSystem.getAllWoods());
            this.listBox = controlListBox;
        }

        private static class WoodModeControlListBox
        extends ControlListBox<ItemStack> {
            public WoodModeControlListBox(WoodModeWidgets woodModeWidgets, IArea area) {
                super(woodModeWidgets.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public IWidget createOption(ItemStack value, int y) {
                return new ControlItemStackOption((ControlList)this.getContent(), value, y);
            }
        }
    }

    private static class FruitModeWidgets
    extends WindowAbstractDatabase.ModeWidgets {
        private WindowArboristDatabase windowArboristDatabase;

        public FruitModeWidgets(WindowArboristDatabase windowArboristDatabase) {
            super(TreeMode.FRUIT, windowArboristDatabase);
            this.windowArboristDatabase = windowArboristDatabase;
        }

        @Override
        public void createListBox(IArea area) {
            FruitModeControlListBox controlListBox = new FruitModeControlListBox(this, area);
            ITreeBreedingSystem breedingSystem = (ITreeBreedingSystem)((Object)this.windowArboristDatabase.getBreedingSystem());
            controlListBox.setOptions(breedingSystem.getAllFruits());
            this.listBox = controlListBox;
        }

        private static class FruitModeControlListBox
        extends ControlListBox<ItemStack> {
            public FruitModeControlListBox(FruitModeWidgets fruitModeWidgets, IArea area) {
                super(fruitModeWidgets.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public IWidget createOption(ItemStack value, int y) {
                return new ControlItemStackOption((ControlList)this.getContent(), value, y);
            }
        }
    }

    static enum TreeMode implements IDatabaseMode
    {
        FRUIT,
        WOOD,
        PLANKS;


        @Override
        public String getName() {
            return I18N.localise("extratrees.gui.database.mode." + this.name().toLowerCase());
        }
    }
}

