/*
 * Decompiled with CFR 0.152.
 */
package binnie.design.gui;

import binnie.core.machines.Machine;
import binnie.core.machines.component.ComponentRecipe;
import binnie.core.machines.component.IComponentRecipe;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.errors.IErrorStateSource;
import binnie.core.machines.network.INetwork;
import binnie.design.Design;
import binnie.design.EnumDesign;
import binnie.design.api.IDesign;
import binnie.design.api.IDesignMaterial;
import binnie.design.api.IDesignerType;
import binnie.design.gui.DesignErrorCode;
import binnie.design.gui.DesignerSlots;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ComponentDesignerRecipe
extends ComponentRecipe
implements IComponentRecipe,
INetwork.GuiNBT,
IErrorStateSource {
    public IDesignerType type;
    private IDesign design = EnumDesign.Diamond;

    public ComponentDesignerRecipe(Machine machine, IDesignerType type) {
        super(machine);
        this.type = type;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.setDesign(Design.getDesignManager().getDesign(nbttagcompound.func_74762_e("design")));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound1) {
        NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound1);
        nbttagcompound.func_74768_a("design", Design.getDesignManager().getDesignIndex(this.design));
        return nbttagcompound;
    }

    @Override
    public boolean isRecipe() {
        return !this.getProduct().func_190926_b();
    }

    @Override
    public ItemStack getProduct() {
        ItemStack plank1 = this.getUtil().getStack(DesignerSlots.DESIGN_SLOT_1);
        ItemStack plank2 = this.getUtil().getStack(DesignerSlots.DESIGN_SLOT_2);
        if (plank1.func_190926_b() || plank2.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        IDesignMaterial type1 = this.type.getSystem().getMaterial(plank1);
        IDesignMaterial type2 = this.type.getSystem().getMaterial(plank2);
        IDesign design = this.getDesign();
        return this.type.getBlock(type1, type2, design);
    }

    @Override
    public ItemStack doRecipe(boolean takeItem) {
        if (!this.isRecipe()) {
            return ItemStack.field_190927_a;
        }
        if (this.canWork() != null) {
            return ItemStack.field_190927_a;
        }
        ItemStack product = this.getProduct();
        if (takeItem) {
            ItemStack a = this.getUtil().decreaseStack(DesignerSlots.DESIGN_SLOT_1, 1);
            if (a.func_190926_b()) {
                this.getUtil().decreaseStack(DesignerSlots.DESIGN_SLOT_2, 1);
            } else if (this.design != EnumDesign.Blank) {
                this.getUtil().decreaseStack(DesignerSlots.DESIGN_SLOT_2, 1);
            }
            this.getUtil().decreaseStack(DesignerSlots.ADHESIVE_SLOT, 1);
        }
        return product;
    }

    public IDesign getDesign() {
        return this.design;
    }

    private void setDesign(IDesign design) {
        this.design = design;
    }

    @Override
    @Nullable
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(DesignerSlots.ADHESIVE_SLOT)) {
            return new ErrorState((IErrorStateDefinition)DesignErrorCode.DESIGNER_NO_ADHESIVE, DesignerSlots.ADHESIVE_SLOT);
        }
        return null;
    }

    @Override
    @Nullable
    public ErrorState canProgress() {
        return null;
    }

    @Override
    public void sendGuiNBTToClient(Map<String, NBTTagCompound> nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74777_a("d", (short)Design.getDesignManager().getDesignIndex(this.getDesign()));
        nbt.put("design", tag);
    }

    @Override
    public void receiveGuiNBTOnClient(EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("design")) {
            this.setDesign(Design.getDesignManager().getDesign(nbt.func_74765_d("d")));
        }
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("recipe")) {
            InventoryPlayer playerInv = player.field_71071_by;
            ItemStack recipe = this.doRecipe(false);
            if (!recipe.func_190926_b()) {
                int fit;
                if (playerInv.func_70445_o().func_190926_b()) {
                    playerInv.func_70437_b(this.doRecipe(true));
                } else if (playerInv.func_70445_o().func_77969_a(recipe) && ItemStack.func_77970_a((ItemStack)playerInv.func_70445_o(), (ItemStack)recipe) && (fit = recipe.func_77976_d() - (recipe.func_190916_E() + playerInv.func_70445_o().func_190916_E())) >= 0) {
                    this.doRecipe(true);
                    recipe.func_190917_f(playerInv.func_70445_o().func_190916_E());
                    playerInv.func_70437_b(recipe);
                }
                player.field_71070_bA.func_75142_b();
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71113_k();
                }
            }
        } else if (name.equals("design")) {
            this.setDesign(Design.getDesignManager().getDesign(nbt.func_74762_e("d")));
        }
    }

    public IDesignerType getDesignerType() {
        return this.type;
    }
}

