/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.resource.stylesheet;

import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Border;
import binnie.core.gui.resource.stylesheet.ParsedTextureSheet;
import binnie.core.gui.resource.stylesheet.StyleSheet;
import binnie.core.gui.resource.textures.Texture;
import binnie.core.resource.IBinnieTexture;
import binnie.core.util.Log;
import com.google.common.base.Charsets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;

public class StyleSheetParser {
    public static final String SHEETS_KEY = "texture-sheets";
    public static final String NAME_KEY = "name";
    public static final String MODID_KEY = "modid";
    public static final String PATH_KEY = "path";
    public static final String SHEET_KEY = "sheet";
    public static final String UV_KEY = "uv";
    public static final String BORDER_KEY = "border";
    public static final String PADDING_KEY = "padding";
    public static final String TEXTURES_KEY = "textures";

    public static StyleSheet parseSheet(IResourceManager manager, ResourceLocation location) {
        try {
            IResource res = manager.func_110536_a(location);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(res.func_110527_b(), Charsets.UTF_8));
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = jsonParser.parse((Reader)bufferedreader).getAsJsonObject();
            Map<String, ParsedTextureSheet> textureSheets = StyleSheetParser.parseTextureSheets(jsonObject);
            Map<String, Texture> textures = StyleSheetParser.parseTextures(jsonObject, textureSheets);
            IOUtils.closeQuietly((Reader)bufferedreader);
            return new StyleSheet(textures);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load default stylesheet for Binnie's Mods.", e);
        }
    }

    private static Map<String, ParsedTextureSheet> parseTextureSheets(JsonObject jsonObject) {
        JsonArray textureSheetsArray = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)SHEETS_KEY);
        if (textureSheetsArray == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ParsedTextureSheet> textureSheets = new HashMap<String, ParsedTextureSheet>();
        for (JsonElement element : textureSheetsArray) {
            if (!element.isJsonObject()) continue;
            try {
                JsonObject sheetJson = (JsonObject)element;
                String name = JsonUtils.func_151200_h((JsonObject)sheetJson, (String)NAME_KEY);
                String modid = JsonUtils.func_151200_h((JsonObject)sheetJson, (String)MODID_KEY);
                String path = JsonUtils.func_151200_h((JsonObject)sheetJson, (String)PATH_KEY);
                ParsedTextureSheet textureSheet = new ParsedTextureSheet(modid, path);
                textureSheets.put(name, textureSheet);
            }
            catch (Exception e) {
                Log.warning("Failed to load stylesheet for Binnie's Mods.", e);
            }
        }
        return textureSheets;
    }

    private static Map<String, Texture> parseTextures(JsonObject jsonObject, Map<String, ParsedTextureSheet> textureSheets) {
        JsonArray texturesJson = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)TEXTURES_KEY);
        if (texturesJson == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Texture> textures = new HashMap<String, Texture>();
        for (JsonElement element : texturesJson) {
            if (!element.isJsonObject()) continue;
            try {
                JsonArray array;
                JsonObject sheetJson = element.getAsJsonObject();
                String name = JsonUtils.func_151200_h((JsonObject)sheetJson, (String)NAME_KEY);
                String sheet = JsonUtils.func_151200_h((JsonObject)sheetJson, (String)SHEET_KEY);
                JsonArray uvArray = JsonUtils.func_151214_t((JsonObject)sheetJson, (String)UV_KEY);
                IBinnieTexture textureSheet = textureSheets.get(sheet);
                Area uv = StyleSheetParser.parseArea(uvArray);
                Border border = Border.ZERO;
                Border padding = Border.ZERO;
                if (sheetJson.has(BORDER_KEY)) {
                    array = JsonUtils.func_151214_t((JsonObject)sheetJson, (String)BORDER_KEY);
                    border = StyleSheetParser.parseBorder(array);
                }
                if (sheetJson.has(PADDING_KEY)) {
                    array = JsonUtils.func_151214_t((JsonObject)sheetJson, (String)PADDING_KEY);
                    padding = StyleSheetParser.parseBorder(array);
                }
                Texture texture = new Texture(uv, padding, border, textureSheet);
                textures.put(name, texture);
            }
            catch (Exception e) {
                Log.warning("Failed to load stylesheet for Binnie's Mods.", e);
            }
        }
        return textures;
    }

    private static Area parseArea(JsonArray uvArray) {
        int[] ints = new int[uvArray.size()];
        if (ints.length < 1 || ints.length > 4) {
            throw new JsonParseException("Parameter must have between one and four numbers");
        }
        for (int i = 0; i < uvArray.size(); ++i) {
            JsonElement object = uvArray.get(i);
            ints[i] = JsonUtils.func_151215_f((JsonElement)object, (String)(UV_KEY + i));
        }
        if (ints.length == 1) {
            return new Area(ints[0]);
        }
        if (ints.length == 2) {
            return new Area(ints[0], ints[1]);
        }
        if (ints.length == 3) {
            return new Area(ints[0], ints[1], ints[2]);
        }
        return new Area(ints[0], ints[1], ints[2], ints[3]);
    }

    private static Border parseBorder(JsonArray array) {
        int[] ints = new int[array.size()];
        if (ints.length < 1 || ints.length > 4) {
            throw new JsonParseException("Parameter must have between one and four numbers");
        }
        for (int i = 0; i < array.size(); ++i) {
            JsonElement object = array.get(i);
            ints[i] = JsonUtils.func_151215_f((JsonElement)object, (String)(UV_KEY + i));
        }
        if (ints.length == 1) {
            return new Border(ints[0]);
        }
        if (ints.length == 2) {
            return new Border(ints[0], ints[1]);
        }
        if (ints.length == 3) {
            return new Border(ints[0], ints[1], ints[2]);
        }
        return new Border(ints[0], ints[1], ints[2], ints[3]);
    }
}

