/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.inoculator;

import binnie.core.api.genetics.IGene;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineUtil;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.machine.GeneticsErrorCode;
import binnie.genetics.machine.inoculator.Inoculator;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InoculatorLogic
extends ComponentProcess
implements IProcess {
    public static final int PROCESS_BASE_LENGTH = 12000;
    public static final int PROCESS_BASE_ENERGY = 600000;
    public static final int BACTERIA_PER_PROCESS = 15;
    private float bacteriaDrain = 0.0f;

    public InoculatorLogic(Machine machine) {
        super(machine);
    }

    public static int getProcessLength(ItemStack itemStack) {
        return 12000 * InoculatorLogic.getNumberOfGenes(itemStack);
    }

    public static int getProcessBaseEnergy(ItemStack itemStack) {
        return 600000 * InoculatorLogic.getNumberOfGenes(itemStack);
    }

    private static int getNumberOfGenes(ItemStack serum) {
        if (serum.func_190926_b()) {
            return 1;
        }
        return Engineering.getGenes(serum).length;
    }

    public static ItemStack applySerum(ItemStack target, ItemStack serum) {
        IGene[] genes;
        ItemStack applied = target.func_77946_l();
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(applied);
        if (!ind.isAnalyzed()) {
            ind.analyze();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            ind.writeToNBT(nbttagcompound);
            applied.func_77982_d(nbttagcompound);
        }
        for (IGene gene : genes = ((IItemSerum)serum.func_77973_b()).getGenes(serum)) {
            Inoculator.setGene(gene, applied, 0);
            Inoculator.setGene(gene, applied, 1);
        }
        if (applied.func_77952_i() == Short.MAX_VALUE) {
            applied.func_77964_b(0);
        }
        return applied;
    }

    @Override
    public int getProcessLength() {
        ItemStack stack = this.getUtil().getStack(0);
        return InoculatorLogic.getProcessLength(stack);
    }

    @Override
    public int getProcessEnergy() {
        ItemStack stack = this.getUtil().getStack(0);
        return InoculatorLogic.getProcessBaseEnergy(stack);
    }

    @Override
    public String getTooltip() {
        ItemStack stack = this.getUtil().getStack(0);
        int n = InoculatorLogic.getNumberOfGenes(stack);
        if (n > 1) {
            return String.format(I18N.localise("genetics.machine.machine.inoculator.tooltips.logic.genes"), Integer.valueOf(n).toString());
        }
        return I18N.localise("genetics.machine.machine.inoculator.tooltips.logic.gene");
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(9)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_INDIVIDUAL, 9);
        }
        if (this.getUtil().isSlotEmpty(0)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_SERUM, 0);
        }
        ErrorState state = this.isValidSerum();
        if (state != null) {
            return state;
        }
        ItemStack serum = this.getUtil().getStack(0);
        if (!serum.func_190926_b() && Engineering.getCharges(serum) == 0) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.EMPTY_SERUM, 0);
        }
        if (this.getUtil().isTankEmpty(0)) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.INOCULATOR_INSUFFICIENT_VECTOR, 0);
        }
        return super.canWork();
    }

    @Nullable
    public ErrorState isValidSerum() {
        ItemStack serum = this.getUtil().getStack(0);
        ItemStack target = this.getUtil().getStack(9);
        IGene[] genes = Engineering.getGenes(serum);
        if (genes.length == 0) {
            return new ErrorState(GeneticsErrorCode.INVALID_SERUM_NO);
        }
        if (!genes[0].getSpeciesRoot().isMember(target)) {
            return new ErrorState(GeneticsErrorCode.INVALID_SERUM_MISMATCH);
        }
        IIndividual individual = genes[0].getSpeciesRoot().getMember(target);
        if (individual != null) {
            IGenome genome = individual.getGenome();
            for (IGene gene : genes) {
                IAllele a = genome.getActiveAllele(gene.getChromosome());
                IAllele b = genome.getInactiveAllele(gene.getChromosome());
                if (a.getUID().equals(gene.getAllele().getUID()) && b.getUID().equals(gene.getAllele().getUID())) continue;
                return null;
            }
        }
        return new ErrorState(GeneticsErrorCode.DEFUNCT_SERUM);
    }

    @Override
    public ErrorState canProgress() {
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        MachineUtil util = this.getUtil();
        ItemStack serum = util.getStack(0);
        ItemStack target = util.getStack(9);
        ItemStack applied = InoculatorLogic.applySerum(target, serum);
        util.setStack(9, applied);
        util.damageItem(serum, 0, 1);
    }

    @Override
    protected void onTickTask() {
        this.bacteriaDrain += 15.0f / (float)this.getProcessLength();
        if (this.bacteriaDrain >= 1.0f) {
            this.getUtil().drainTank(0, 1);
            this.bacteriaDrain -= 1.0f;
        }
    }
}

