/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.wood.planks;

import binnie.core.util.I18N;
import binnie.extratrees.wood.planks.IPlankType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum VanillaPlanks implements IPlankType
{
    OAK(11833434, (IWoodType)EnumVanillaWoodType.OAK),
    SPRUCE(8412726, (IWoodType)EnumVanillaWoodType.SPRUCE),
    BIRCH(14139781, (IWoodType)EnumVanillaWoodType.BIRCH),
    JUNGLE(11632732, (IWoodType)EnumVanillaWoodType.JUNGLE),
    ACACIA(12215095, (IWoodType)EnumVanillaWoodType.ACACIA),
    BIG_OAK(4599061, (IWoodType)EnumVanillaWoodType.DARK_OAK);

    private final IWoodType woodType;
    private int color;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite sprite;

    private VanillaPlanks(int color, IWoodType woodType) {
        this.color = color;
        this.woodType = woodType;
    }

    public String getDesignMaterialName() {
        return I18N.localise("extratrees.block.planks.vanilla." + this.toString().toLowerCase());
    }

    @Override
    public String getDescription() {
        return I18N.localise("extratrees.block.planks.vanilla." + this.toString().toLowerCase() + ".desc");
    }

    @Override
    public String getPlankTextureName() {
        return "minecraft:blocks/planks_" + this.name().toLowerCase();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureMap map) {
        this.sprite = map.func_174942_a(new ResourceLocation(this.getPlankTextureName()));
    }

    public int getColour() {
        return this.color;
    }

    public ItemStack getStack() {
        return this.getStack(true);
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    public ItemStack getStack(boolean fireproof) {
        return TreeManager.woodAccess.getStack(this.woodType, WoodBlockKind.PLANKS, fireproof);
    }
}

