/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.Binnie;
import binnie.core.liquid.AlcoholEffect;
import binnie.core.liquid.DrinkManager;
import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidHandlerItemBinnie;
import binnie.core.liquid.FluidType;
import binnie.core.liquid.IDrinkLiquid;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidContainer
extends ItemFood
implements IItemModelRegister {
    private final FluidContainerType container;

    public ItemFluidContainer(FluidContainerType container) {
        super(0, false);
        this.container = container;
        container.setItem(this);
        this.field_77777_bU = container.getMaxStackSize();
        this.func_77627_a(true);
        this.func_77655_b("container" + container.getName());
        this.func_77637_a(CreativeTabs.field_78035_l);
        this.setRegistryName(container.getName());
    }

    public String func_77653_i(ItemStack itemstack) {
        FluidStack fluid = this.getContained(itemstack);
        if (fluid == null) {
            return "Empty " + this.container.getDisplayName();
        }
        return fluid.getFluid().getLocalizedName(fluid) + " " + this.container.getDisplayName();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        super.func_150895_a(tab, items);
        if (this.func_194125_a(tab)) {
            for (FluidType type : Binnie.LIQUID.getFluids().values()) {
                if (!type.canPlaceIn(this.container) || !type.showInCreative(this.container)) continue;
                items.add((Object)this.getContainer(type));
            }
        }
    }

    @Nullable
    protected FluidStack getContained(ItemStack itemStack) {
        if (itemStack.func_190916_E() != 1) {
            itemStack = itemStack.func_77946_l();
            itemStack.func_190920_e(1);
        }
        FluidHandlerItemBinnie fluidHandler = new FluidHandlerItemBinnie(itemStack, this.container);
        return fluidHandler.drain(Integer.MAX_VALUE, false);
    }

    public ItemStack getContainer(FluidType type) {
        ItemStack itemStack = new ItemStack((Item)this);
        FluidHandlerItemBinnie fluidHandler = new FluidHandlerItemBinnie(itemStack, this.container);
        FluidStack fluidStack = type.get();
        if (fluidStack == null) {
            return this.container.getEmpty();
        }
        if (fluidHandler.fill(fluidStack, true) == 1000) {
            return itemStack;
        }
        return this.container.getEmpty();
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            player.func_71024_bL().func_151686_a((ItemFood)this, stack);
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.func_77849_c(stack, world, player);
            return this.container.getEmpty();
        }
        return stack;
    }

    protected void func_77849_c(ItemStack itemStack, World world, EntityPlayer player) {
        IDrinkLiquid liquid;
        FluidStack fluid;
        if (!world.field_72995_K && (fluid = this.getContained(itemStack)) != null && (liquid = DrinkManager.getLiquid(fluid)) != null) {
            AlcoholEffect.makeDrunk(player, liquid.getABV() * (float)fluid.amount);
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this.isDrinkable(stack)) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (this.isDrinkable(stack) && playerIn.func_71043_e(false)) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public int func_77626_a(ItemStack stack) {
        if (this.isDrinkable(stack)) {
            return 32;
        }
        return 0;
    }

    public float func_150906_h(ItemStack stack) {
        return 0.0f;
    }

    public int func_150905_g(ItemStack stack) {
        return 0;
    }

    private boolean isDrinkable(ItemStack stack) {
        FluidStack fluid = this.getContained(stack);
        if (fluid == null) {
            return false;
        }
        IDrinkLiquid liquid = DrinkManager.getLiquid(fluid);
        return liquid != null && liquid.isConsumable();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        FluidContainerMeshDefinition meshDefinition = new FluidContainerMeshDefinition();
        manager.registerItemModel(item, (ItemMeshDefinition)meshDefinition);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{meshDefinition.location, meshDefinition.empty});
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemBinnie(stack, this.container);
    }

    @SideOnly(value=Side.CLIENT)
    private class FluidContainerMeshDefinition
    implements ItemMeshDefinition {
        final ModelResourceLocation location;
        final ModelResourceLocation empty;

        public FluidContainerMeshDefinition() {
            ResourceLocation location = ItemFluidContainer.this.getRegistryName();
            this.location = new ModelResourceLocation(location, "inventory");
            this.empty = new ModelResourceLocation(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + "_empty"), "inventory");
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            if (stack.func_77952_i() == 0) {
                return this.empty;
            }
            return this.location;
        }
    }
}

