/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.core.api.gui.IWidget;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.database.ControlIndividualDisplay;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.EnumDiscoveryState;
import binnie.core.gui.database.PageSpecies;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.util.I18N;
import forestry.api.genetics.IAlleleSpecies;
import java.util.Objects;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PageSpeciesOverview
extends PageSpecies {
    private ControlText controlName;
    private ControlText controlScientific;
    private ControlText controlAuthority;
    private ControlText controlComplexity;
    private ControlText controlDescription;
    private ControlText controlSignature;
    private ControlIndividualDisplay controlInd1 = new ControlIndividualDisplay(this, 5, 5);
    private ControlIndividualDisplay controlInd2 = new ControlIndividualDisplay(this, 123, 5);

    public PageSpeciesOverview(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
        this.controlName = new ControlTextCentered((IWidget)this, 8, "");
        this.controlScientific = new ControlTextCentered((IWidget)this, 32, "");
        this.controlAuthority = new ControlTextCentered((IWidget)this, 44, "");
        this.controlComplexity = new ControlTextCentered((IWidget)this, 68, "");
        this.controlDescription = new ControlText(this, new Area(8, 84, this.getSize().xPos() - 16, 0), "", TextJustification.MIDDLE_CENTER);
        this.controlSignature = new ControlText(this, new Area(8, 84, this.getSize().xPos() - 16, 0), "", TextJustification.BOTTOM_RIGHT);
    }

    @Override
    public void onValueChanged(IAlleleSpecies species) {
        this.controlInd1.setSpecies(species, EnumDiscoveryState.SHOW);
        this.controlInd2.setSpecies(species, EnumDiscoveryState.SHOW);
        String branchBinomial = species.getBranch().getScientific();
        this.controlName.setValue(TextFormatting.UNDERLINE + species.getAlleleName());
        this.controlScientific.setValue(TextFormatting.ITALIC + branchBinomial + " " + species.getBinomial());
        this.controlAuthority.setValue(I18N.localise("binniecore.gui.database.discovered") + ": " + TextFormatting.BOLD + species.getAuthority());
        this.controlComplexity.setValue(I18N.localise("binniecore.gui.database.overview.complexity") + ": " + species.getComplexity());
        String desc = species.getDescription();
        StringBuilder descBody = new StringBuilder(TextFormatting.ITALIC.toString());
        String descSig = "";
        if (desc == null || Objects.equals(desc, "") || desc.contains("for.description") || desc.contains(".desc")) {
            descBody.append(I18N.localise("binniecore.gui.database.no.description"));
        } else {
            String[] descStrings = desc.split("\\|");
            descBody.append(descStrings[0]);
            for (int i = 1; i < descStrings.length - 1; ++i) {
                descBody.append(" ").append(descStrings[i]);
            }
            if (descStrings.length > 1) {
                descSig = descSig + descStrings[descStrings.length - 1];
            }
        }
        this.controlDescription.setValue(descBody.toString() + TextFormatting.RESET);
        this.controlSignature.setValue(descSig);
        int descHeight = CraftGUI.RENDER.textHeight(this.controlDescription.getValue(), this.controlDescription.getSize().xPos());
        this.controlSignature.setPosition(new Point(this.controlSignature.getPosition().xPos(), this.controlDescription.getPosition().yPos() + descHeight + 10));
    }
}

