/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics.gui.database;

import binnie.core.api.gui.IWidget;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.PageBranchOverview;
import binnie.core.gui.database.PageBranchSpecies;
import binnie.core.gui.database.PageBreeder;
import binnie.core.gui.database.PageSpeciesClassification;
import binnie.core.gui.database.PageSpeciesMutations;
import binnie.core.gui.database.PageSpeciesOverview;
import binnie.core.gui.database.PageSpeciesResultant;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.minecraft.Window;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.gui.PageSpeciesClimate;
import binnie.extrabees.gui.PageSpeciesGenome;
import binnie.extrabees.gui.PageSpeciesProducts;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowApiaristDatabase
extends WindowAbstractDatabase {
    public WindowApiaristDatabase(EntityPlayer player, Side side, boolean master) {
        super(player, side, master, ExtraBees.beeBreedingSystem, 110);
    }

    public static Window create(EntityPlayer player, Side side, boolean master) {
        return new WindowApiaristDatabase(player, side, master);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addTabs() {
        new PageSpeciesOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab("genetics", "species.overview"));
        new PageSpeciesClassification((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab("genetics", "species.classification"));
        new PageSpeciesGenome((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab("genetics", "species.genome"));
        new PageSpeciesProducts((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab("genetics", "species.products"));
        new PageSpeciesClimate((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab("genetics", "species.climate"));
        new PageSpeciesResultant((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab("genetics", "species.resultant"));
        new PageSpeciesMutations((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab("genetics", "species.further"));
        new PageBranchOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab("genetics", "branches.overview"));
        new PageBranchSpecies((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab("genetics", "branches.species"));
        new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.BREEDER), this.getUsername(), new DatabaseTab("genetics", "breeder"));
    }

    @Override
    public String getModId() {
        return "extrabees";
    }

    @Override
    public String getBackgroundTextureName() {
        return "Database";
    }

    static enum BranchesTab {
        Overview(255),
        Species(0xFF0000);

        public int color;

        private BranchesTab(int color) {
            this.color = color;
        }
    }

    static enum SpeciesTab {
        Overview(255),
        Genome(0xFFFF00),
        Productivity(65535),
        Climate(0xFF0000),
        ResultantMutations(0xFF00FF),
        FurtherMutations(65280);

        public int color;

        private SpeciesTab(int color) {
            this.color = color;
        }
    }
}

