/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.incubator;

import binnie.core.machines.Machine;
import binnie.core.machines.errors.CoreErrorCode;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.transfer.TransferRequest;
import binnie.genetics.machine.GeneticsErrorCode;
import binnie.genetics.machine.incubator.IIncubatorRecipe;
import binnie.genetics.machine.incubator.Incubator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class IncubatorLogic
extends ComponentProcessIndefinate
implements IProcess {
    @Nullable
    private IIncubatorRecipe recipe = null;
    private Random rand = new Random();
    private boolean roomForOutput = true;

    public IncubatorLogic(Machine machine) {
        super(machine, 2.0f);
    }

    private static boolean isStackValid(ItemStack stack, IIncubatorRecipe recipe) {
        return OreDictionary.itemMatches((ItemStack)recipe.getInputStack(), (ItemStack)stack, (boolean)false);
    }

    @Override
    public ErrorState canWork() {
        if (this.recipe == null) {
            return new ErrorState(CoreErrorCode.NO_RECIPE);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (this.recipe != null) {
            if (!this.recipe.isInputLiquidSufficient(this.getUtil().getFluid(0))) {
                return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.INCUBATOR_INSUFFICIENT_LIQUID, 0);
            }
            if (!this.roomForOutput) {
                return new ErrorState((IErrorStateDefinition)CoreErrorCode.NO_SPACE_TANK, 1);
            }
        }
        return super.canProgress();
    }

    @Override
    protected void onTickTask() {
        if (this.rand.nextInt(20) == 0 && this.recipe != null && this.rand.nextFloat() < this.recipe.getChance()) {
            this.recipe.doTask(this.getUtil());
        }
    }

    @Override
    public boolean inProgress() {
        return this.recipe != null;
    }

    @Nullable
    private IIncubatorRecipe getRecipe(ItemStack stack, FluidStack liquid) {
        for (IIncubatorRecipe recipe : Incubator.getRecipes()) {
            boolean rightLiquid = recipe.isInputLiquid(liquid);
            boolean rightItem = IncubatorLogic.isStackValid(stack, recipe);
            if (!rightLiquid || !rightItem) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void onInventoryUpdate() {
        super.onInventoryUpdate();
        if (!this.getUtil().isServer()) {
            return;
        }
        FluidStack liquid = this.getUtil().getFluid(0);
        ItemStack incubator = this.getUtil().getStack(3);
        if (!(this.recipe == null || !incubator.func_190926_b() && liquid != null && this.recipe.isInputLiquid(liquid) && IncubatorLogic.isStackValid(incubator, this.recipe))) {
            this.recipe = null;
            ItemStack leftover = new TransferRequest(incubator, this.getInventory()).setTargetSlots(Incubator.SLOT_OUTPUT).ignoreValidation().transfer(true);
            this.getUtil().setStack(3, leftover);
        }
        if (this.recipe == null) {
            IIncubatorRecipe recipe;
            if (liquid == null) {
                return;
            }
            if (!incubator.func_190926_b() && (recipe = this.getRecipe(incubator, liquid)) != null) {
                this.recipe = recipe;
                return;
            }
            IIncubatorRecipe potential = null;
            int potentialSlot = 0;
            block0: for (int slot : Incubator.SLOT_QUEUE) {
                ItemStack stack = this.getUtil().getStack(slot);
                if (stack.func_190926_b() || potential != null) continue;
                for (IIncubatorRecipe recipe2 : Incubator.getRecipes()) {
                    boolean rightLiquid = recipe2.isInputLiquid(liquid);
                    boolean rightItem = IncubatorLogic.isStackValid(stack, recipe2);
                    if (!rightLiquid || !rightItem) continue;
                    potential = recipe2;
                    potentialSlot = slot;
                    continue block0;
                }
            }
            if (potential != null) {
                TransferRequest removal = new TransferRequest(incubator, this.getInventory()).setTargetSlots(Incubator.SLOT_OUTPUT).ignoreValidation();
                if (removal.transfer(false).func_190926_b()) {
                    this.recipe = potential;
                }
                removal.transfer(true);
                ItemStack stack2 = this.getUtil().getStack(potentialSlot);
                this.getUtil().setStack(potentialSlot, ItemStack.field_190927_a);
                this.getUtil().setStack(3, stack2);
            }
        }
        if (this.recipe != null) {
            this.roomForOutput = this.recipe.roomForOutput(this.getUtil());
        }
    }
}

