/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.modules;

import binnie.botany.Botany;
import binnie.botany.api.gardening.EnumAcidity;
import binnie.botany.api.gardening.EnumMoisture;
import binnie.botany.farming.CircuitGarden;
import binnie.botany.items.EnumTubeInsulate;
import binnie.botany.items.EnumTubeMaterial;
import binnie.botany.items.ItemInsulatedTube;
import binnie.core.Mods;
import binnie.core.modules.BinnieModule;
import binnie.core.modules.Module;
import binnie.core.util.RecipeUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@BinnieModule(moduleID="botany.farming", moduleContainerID="botany", name="Farming", unlocalizedDescription="botany.module.farming")
public class ModuleFarming
extends Module {
    public ItemInsulatedTube insulatedTube;

    @Override
    public Set<String> getDependencyUids() {
        return ImmutableSet.of((Object)"botany.flowers");
    }

    @Override
    public void registerItemsAndBlocks() {
        this.insulatedTube = new ItemInsulatedTube();
        Botany.proxy.registerItem(this.insulatedTube);
    }

    @Override
    public void init() {
        ItemStack yellow = new ItemStack((Block)Blocks.field_150327_N, 1);
        ItemStack red = new ItemStack((Block)Blocks.field_150328_O, 1);
        ItemStack blue = new ItemStack((Block)Blocks.field_150328_O, 1, 7);
        for (boolean manual : new boolean[]{true, false}) {
            for (boolean fertilised : new boolean[]{true, false}) {
                for (EnumMoisture moist : EnumMoisture.values()) {
                    ItemStack icon = moist == EnumMoisture.DRY ? yellow : (moist == EnumMoisture.NORMAL ? red : blue);
                    int insulate = 2 - moist.ordinal();
                    if (fertilised) {
                        insulate += 3;
                    }
                    new CircuitGarden(moist, null, manual, fertilised, new ItemStack((Item)this.insulatedTube, 1, 128 * insulate), icon);
                    new CircuitGarden(moist, EnumAcidity.ACID, manual, fertilised, new ItemStack((Item)this.insulatedTube, 1, 1 + 128 * insulate), icon);
                    new CircuitGarden(moist, EnumAcidity.NEUTRAL, manual, fertilised, new ItemStack((Item)this.insulatedTube, 1, 2 + 128 * insulate), icon);
                    new CircuitGarden(moist, EnumAcidity.ALKALINE, manual, fertilised, new ItemStack((Item)this.insulatedTube, 1, 3 + 128 * insulate), icon);
                }
            }
        }
        for (EnumTubeMaterial mat : EnumTubeMaterial.VALUES) {
            RecipeUtil recipeUtil = new RecipeUtil("botany");
            for (EnumTubeInsulate insulate : EnumTubeInsulate.VALUES) {
                ItemStack tubes = new ItemStack((Item)this.insulatedTube, 2, mat.ordinal() + 128 * insulate.ordinal());
                ItemStack insulateStack = ItemInsulatedTube.getInsulateStack(tubes);
                ItemStack forestryTube = new ItemStack(Mods.Forestry.item("thermionic_tubes"), 1, mat.ordinal());
                String recipeName = "thermionic_tubes_" + insulate.getUid() + "_" + mat.getUid();
                recipeUtil.addShapelessRecipe(recipeName, tubes, forestryTube, forestryTube, insulateStack);
            }
        }
    }
}

