/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.craftgui;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.listbox.ControlList;
import binnie.core.craftgui.controls.listbox.ControlListBox;
import binnie.core.craftgui.database.ControlItemStackOption;
import binnie.core.craftgui.database.DatabaseTab;
import binnie.core.craftgui.database.IDatabaseMode;
import binnie.core.craftgui.database.PageBranchOverview;
import binnie.core.craftgui.database.PageBranchSpecies;
import binnie.core.craftgui.database.PageBreeder;
import binnie.core.craftgui.database.PageSpeciesClassification;
import binnie.core.craftgui.database.PageSpeciesMutations;
import binnie.core.craftgui.database.PageSpeciesOverview;
import binnie.core.craftgui.database.PageSpeciesResultant;
import binnie.core.craftgui.database.WindowAbstractDatabase;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.genetics.TreeBreedingSystem;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.block.WoodManager;
import binnie.extratrees.machines.craftgui.PageFruit;
import binnie.extratrees.machines.craftgui.PagePlanksOverview;
import binnie.extratrees.machines.craftgui.PagePlanksTrees;
import binnie.extratrees.machines.craftgui.PageSpeciesTreeGenome;
import binnie.extratrees.machines.craftgui.PageWood;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowArboristDatabase
extends WindowAbstractDatabase {
    ControlListBox<ItemStack> selectionBoxFruit;
    ControlListBox<ItemStack> selectionBoxWood;
    ControlListBox<ItemStack> selectionBoxPlanks;

    public WindowArboristDatabase(EntityPlayer player, Side side, boolean nei) {
        super(player, side, nei, Binnie.GENETICS.treeBreedingSystem, 120);
    }

    public static Window create(EntityPlayer player, Side side, boolean nei) {
        return new WindowArboristDatabase(player, side, nei);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addTabs() {
        new PageSpeciesOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.overview", 0));
        new PageSpeciesTreeGenome((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.genome", 0));
        new PageSpeciesClassification((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.classification", 0));
        new PageSpeciesResultant((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.resultant", 0));
        new PageSpeciesMutations((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.further", 0));
        new PageBranchOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(ExtraTrees.instance, "branches.overview", 0));
        new PageBranchSpecies((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(ExtraTrees.instance, "branches.species", 0));
        new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.BREEDER), this.getUsername(), new DatabaseTab(ExtraTrees.instance, "breeder", 0));
        this.createMode(TreeMode.FRUIT, new WindowAbstractDatabase.ModeWidgets(TreeMode.FRUIT, this){

            @Override
            public void createListBox(Area area) {
                ControlListBox<ItemStack> controlListBox = new ControlListBox<ItemStack>((IWidget)this.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public IWidget createOption(ItemStack value, int y) {
                        return new ControlItemStackOption((ControlList)this.getContent(), value, y);
                    }
                };
                controlListBox.setOptions(((TreeBreedingSystem)WindowArboristDatabase.this.getBreedingSystem()).allFruits);
                this.listBox = controlListBox;
            }
        });
        this.createMode(TreeMode.WOOD, new WindowAbstractDatabase.ModeWidgets(TreeMode.WOOD, this){

            @Override
            public void createListBox(Area area) {
                ControlListBox<ItemStack> controlListBox = new ControlListBox<ItemStack>((IWidget)this.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public IWidget createOption(ItemStack value, int y) {
                        return new ControlItemStackOption((ControlList)this.getContent(), value, y);
                    }
                };
                controlListBox.setOptions(((TreeBreedingSystem)WindowArboristDatabase.this.getBreedingSystem()).allWoods);
                this.listBox = controlListBox;
            }
        });
        this.createMode(TreeMode.PLANKS, new WindowAbstractDatabase.ModeWidgets(TreeMode.PLANKS, this){

            @Override
            public void createListBox(Area area) {
                ControlListBox<ItemStack> controlListBox = new ControlListBox<ItemStack>((IWidget)this.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public IWidget createOption(ItemStack value, int y) {
                        return new ControlItemStackOption((ControlList)this.getContent(), value, y);
                    }
                };
                controlListBox.setOptions(WoodManager.getAllPlankTypes().stream().map(IDesignMaterial::getStack).collect(Collectors.toList()));
                this.listBox = controlListBox;
            }
        });
        new PageFruit(this.getInfoPages(TreeMode.FRUIT), new DatabaseTab(ExtraTrees.instance, "fruit.natural", 0), true);
        new PageFruit(this.getInfoPages(TreeMode.FRUIT), new DatabaseTab(ExtraTrees.instance, "fruit.potential", 0), false);
        new PageWood((IWidget)this.getInfoPages(TreeMode.WOOD), new DatabaseTab(ExtraTrees.instance, "wood.natural", 0));
        new PagePlanksOverview((IWidget)this.getInfoPages(TreeMode.PLANKS), new DatabaseTab(ExtraTrees.instance, "planks.overview", 0));
        new PagePlanksTrees((IWidget)this.getInfoPages(TreeMode.PLANKS), new DatabaseTab(ExtraTrees.instance, "planks.natural", 1));
    }

    @Override
    protected AbstractMod getMod() {
        return ExtraTrees.instance;
    }

    @Override
    protected String getBackgroundTextureName() {
        return "TreeDatabase";
    }

    static enum TreeMode implements IDatabaseMode
    {
        FRUIT,
        WOOD,
        PLANKS;


        @Override
        public String getName() {
            return I18N.localise("extratrees.gui.database.mode." + this.name().toLowerCase());
        }
    }
}

