package binnie.botany.ceramic;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

import net.minecraftforge.common.ForgeHooks;

import binnie.botany.Botany;
import binnie.botany.ceramic.brick.CeramicBrickType;

public class CeramicTileRecipe implements IRecipe {
	private ItemStack cached = ItemStack.field_190927_a;

	@Override
	public boolean func_77569_a(InventoryCrafting inv, World world) {
		cached = func_77572_b(inv);
		return !cached.func_190926_b();
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv) {
		Item ceramicBlock = Item.func_150898_a(Botany.ceramic);
		Item ceramicTile = Item.func_150898_a(Botany.ceramicTile);
		Item ceramicBrick = Item.func_150898_a(Botany.ceramicBrick);
		Item mortar = Botany.misc;
		List<ItemStack> stacks = new ArrayList<>();
		int ix = -1;
		int iy = -1;
		for (int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if (!stack.func_190926_b()) {
				int x = i / 3;
				int y = i % 3;
				if (ix == -1) {
					ix = x;
					iy = y;
				}
				if (x - ix >= 2 || y - iy >= 2 || y < iy || x < ix) {
					return ItemStack.field_190927_a;
				}
				if (stack.func_77973_b() != ceramicBlock && stack.func_77973_b() != ceramicTile && stack.func_77973_b() != ceramicBrick && stack.func_77973_b() != mortar) {
					return ItemStack.field_190927_a;
				}
				stacks.add(stack);
			}
		}
		for (CeramicBrickType type : CeramicBrickType.VALUES) {
			ItemStack result = type.getRecipe(stacks);
			if (!result.func_190926_b()) {
				return result;
			}
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public int func_77570_a() {
		return 2;
	}

	@Override
	public ItemStack func_77571_b() {
		return cached;
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
		return ForgeHooks.defaultRecipeGetRemainingItems(inv);
	}
}
