/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.geometry.Area;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.util.I18N;
import binnie.genetics.gui.ControlAnalystPage;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflyEffect;
import forestry.api.lepidopterology.IButterfly;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AnalystPageBehaviour
extends ControlAnalystPage {
    public AnalystPageBehaviour(IWidget parent, Area area, IIndividual ind) {
        super(parent, area);
        this.setColor(0x660033);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, "\u00a7nBehaviour").setColor(this.getColor());
        y += 12;
        if (ind instanceof IBee) {
            IBee bee = (IBee)ind;
            int fertility = bee.getGenome().getFlowering();
            new ControlTextCentered((IWidget)this, y += 8, "Pollinates nearby\n" + bee.getGenome().getFlowerProvider().getDescription()).setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 20, "\u00a7oEvery " + this.getTimeString(55000 / fertility)).setColor(this.getColor());
            y += 22;
            IAlleleBeeEffect effect = bee.getGenome().getEffect();
            Vec3i t = bee.getGenome().getTerritory();
            if (!effect.getUID().contains("None")) {
                String effectDesc = I18N.localiseOrBlank("binniecore.allele." + effect.getUID() + ".desc");
                String loc = effectDesc.equals("") ? "Effect: " + effect.getName() : effectDesc;
                new ControlText(this, new Area(4, y, this.width() - 8, 0), loc, TextJustification.TOP_CENTER).setColor(this.getColor());
                new ControlTextCentered((IWidget)this, y += CraftGUI.render.textHeight(loc, this.width() - 8) + 1, "\u00a7oWithin " + t.func_177958_n() / 2 + " blocks").setColor(this.getColor());
                y += 22;
            }
            new ControlTextCentered((IWidget)this, y, "Territory: \u00a7o" + t.func_177958_n() + "x" + t.func_177956_o() + "x" + t.func_177952_p()).setColor(this.getColor());
            y += 22;
        }
        if (ind instanceof IButterfly) {
            IButterfly bee2 = (IButterfly)ind;
            new ControlTextCentered((IWidget)this, y, "\u00a7oMetabolism: " + Binnie.GENETICS.mothBreedingSystem.getAlleleName((IChromosomeType)EnumButterflyChromosome.METABOLISM, ind.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.METABOLISM))).setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 20, "Pollinates nearby\n" + bee2.getGenome().getFlowerProvider().getDescription()).setColor(this.getColor());
            new ControlTextCentered((IWidget)this, y += 20, "\u00a7oEvery " + this.getTimeString(1500)).setColor(this.getColor());
            y += 22;
            IAlleleButterflyEffect effect2 = bee2.getGenome().getEffect();
            if (!effect2.getUID().contains("None")) {
                String effectDesc2 = I18N.localiseOrBlank("binniecore.allele." + effect2.getUID() + ".desc");
                String loc2 = effectDesc2.equals("") ? "Effect: " + effect2.getName() : effectDesc2;
                new ControlText(this, new Area(4, y, this.width() - 8, 0), loc2, TextJustification.TOP_CENTER).setColor(this.getColor());
                y += CraftGUI.render.textHeight(loc2, this.width() - 8) + 1;
                y += 22;
            }
        }
    }

    @Override
    public String getTitle() {
        return "Behaviour";
    }
}

