/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.distillery;

import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.extratrees.machines.distillery.DistilleryRecipes;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class DistilleryLogic
extends ComponentProcessSetCost
implements IProcess,
INetwork.SendGuiNBT,
INetwork.ReceiveGuiNBT {
    public static final int INPUT_FLUID_AMOUNT = 1000;
    @Nullable
    public FluidStack currentFluid = null;
    public int level = 0;

    public DistilleryLogic(Machine machine) {
        super(machine, 16000, 800);
    }

    @Override
    public float getEnergyPerTick() {
        return 2.0f;
    }

    @Override
    public int getProcessLength() {
        return 2000 + 800 * this.level;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.level = nbt.func_74771_c("dlevel");
        NBTTagCompound fluidNbt = nbt.func_74775_l("fluid");
        this.currentFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidNbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt2) {
        NBTTagCompound nbt = super.writeToNBT(nbt2);
        nbt.func_74774_a("dlevel", (byte)this.level);
        NBTTagCompound fluidNbt = new NBTTagCompound();
        if (this.currentFluid != null) {
            this.currentFluid.writeToNBT(fluidNbt);
        }
        nbt.func_74782_a("fluid", (NBTBase)fluidNbt);
        return nbt;
    }

    @Override
    @Nullable
    public ErrorState canWork() {
        if (this.getUtil().isTankEmpty(0) && this.currentFluid == null) {
            return new ErrorState.InsufficientLiquid("No Input Liquid", 0);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        FluidStack inputFluid;
        FluidStack recipeOutput;
        if (this.currentFluid == null) {
            return new ErrorState("Distillery Empty", "No liquid in Distillery");
        }
        FluidStack fluidInOutputTank = this.getUtil().getFluid(1);
        if (fluidInOutputTank != null && (recipeOutput = DistilleryRecipes.getOutput(inputFluid = this.getUtil().getFluid(0), this.level)) != null && !recipeOutput.isFluidEqual(fluidInOutputTank)) {
            return new ErrorState.TankSpace("Different fluid in tank", 1);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        FluidStack output = DistilleryRecipes.getOutput(this.currentFluid, this.level);
        if (output != null) {
            this.getUtil().fillTank(1, output);
        }
        this.currentFluid = null;
    }

    @Override
    protected void onTickTask() {
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
    }

    @Override
    public void receiveGuiNBTOnClient(EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("still-level")) {
            this.level = nbt.func_74771_c("i");
            this.setProgress(0.0f);
        }
        if (name.equals("still-recipe")) {
            this.currentFluid = nbt.func_74767_n("null") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        }
    }

    @Override
    public void sendGuiNBTToClient(Map<String, NBTTagCompound> data) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.currentFluid == null) {
            nbt.func_74757_a("null", true);
        } else {
            this.currentFluid.writeToNBT(nbt);
        }
        data.put("still-recipe", nbt);
        nbt.func_74774_a("i", (byte)this.level);
        data.put("still-level", nbt);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.canWork() == null && this.currentFluid == null && this.getUtil().getTank(0).getFluidAmount() >= 1000) {
            this.currentFluid = this.getUtil().drainTank(0, 1000);
        }
    }

    @Override
    public String getTooltip() {
        if (this.currentFluid == null) {
            return "Empty";
        }
        FluidStack output = DistilleryRecipes.getOutput(this.currentFluid, this.level);
        if (output == null) {
            return "Empty";
        }
        return "Creating " + output.getLocalizedName();
    }
}

