/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.brewery;

import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.extratrees.machines.brewery.BreweryCrafting;
import binnie.extratrees.machines.brewery.BreweryMachine;
import binnie.extratrees.machines.brewery.BreweryRecipes;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class BreweryLogic
extends ComponentProcessSetCost
implements IProcess,
INetwork.GuiNBT {
    @Nullable
    public BreweryCrafting currentCrafting = null;

    public BreweryLogic(Machine machine) {
        super(machine, 16000, 800);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isTankEmpty(0) && this.currentCrafting == null) {
            return new ErrorState.InsufficientLiquid("No Input Liquid", 0);
        }
        if (BreweryRecipes.getOutput(this.getInputCrafting()) == null && this.currentCrafting == null) {
            return new ErrorState("No Recipe", "Brewing cannot occur with these ingredients");
        }
        if (!this.getUtil().hasIngredients(new int[]{0, 1, 2, 3, 4}, BreweryMachine.SLOTS_INVENTORY) && this.currentCrafting == null) {
            return new ErrorState("Insufficient Ingredients", "Not enough ingredients for Brewing");
        }
        return super.canWork();
    }

    private BreweryCrafting getInputCrafting() {
        FluidStack inputFluid = this.getUtil().getFluid(0);
        ItemStack inputIngredient = this.getUtil().getStack(3);
        ItemStack[] inputGrains = this.getUtil().getStacks(BreweryMachine.SLOT_RECIPE_GRAINS);
        ItemStack inputYeast = this.getUtil().getStack(4);
        return new BreweryCrafting(inputFluid, inputIngredient, inputGrains, inputYeast);
    }

    @Override
    public ErrorState canProgress() {
        FluidStack craftingOutputFluid;
        if (this.currentCrafting == null) {
            return new ErrorState("Brewery Empty", "No liquid in Brewery");
        }
        if (!this.getUtil().spaceInTank(1, 1000)) {
            return new ErrorState.TankSpace("No Space for Fermented Liquid", 1);
        }
        FluidStack outputFluid = this.getUtil().getFluid(1);
        if (outputFluid != null && !outputFluid.isFluidEqual(craftingOutputFluid = BreweryRecipes.getOutput(this.currentCrafting))) {
            return new ErrorState.TankSpace("Different fluid in tank", 1);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        Preconditions.checkState((this.currentCrafting != null ? 1 : 0) != 0);
        FluidStack output = BreweryRecipes.getOutput(this.currentCrafting);
        if (output != null) {
            this.getUtil().fillTank(1, output);
            this.currentCrafting = null;
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.canWork() == null && this.currentCrafting == null && this.getUtil().getTank(0).getFluidAmount() >= 1000) {
            FluidStack stack = this.getUtil().drainTank(0, 1000);
            this.currentCrafting = this.getInputCrafting();
            this.currentCrafting.inputFluid = stack;
            this.getUtil().drainTank(0, stack.amount);
            this.getUtil().removeIngredients(new int[]{0, 1, 2, 3, 4}, BreweryMachine.SLOTS_INVENTORY);
        }
    }

    @Override
    public void sendGuiNBTToClient(Map<String, NBTTagCompound> data) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.currentCrafting == null) {
            nbt.func_74757_a("null", true);
        } else {
            this.currentCrafting.writeToNBT(nbt);
        }
        data.put("brewery-recipe", nbt);
    }

    @Override
    public void receiveGuiNBTOnServer(EntityPlayer player, String name, NBTTagCompound nbt) {
    }

    @Override
    public void receiveGuiNBTOnClient(EntityPlayer player, String name, NBTTagCompound nbt) {
        if (name.equals("brewery-recipe")) {
            this.currentCrafting = nbt.func_74767_n("null") ? null : BreweryCrafting.create(nbt);
        }
    }

    @Override
    public String getTooltip() {
        if (this.currentCrafting == null) {
            return "Empty";
        }
        FluidStack output = BreweryRecipes.getOutput(this.currentCrafting);
        if (output == null) {
            return "Empty";
        }
        return "Creating " + output.getFluid().getLocalizedName(output);
    }
}

