package binnie.extratrees.block.wood;

import javax.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.client.model.ModelLoader;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.IWoodTyped;

import binnie.Constants;
import binnie.extratrees.block.EnumShrubLog;

public class BlockShrubLog extends Block implements IWoodTyped, IStateMapperRegister, IItemModelRegister {

	public static final PropertyBool FIREPROOF = PropertyBool.func_177716_a("fireproof");
	public static final PropertyBool NORTH = PropertyBool.func_177716_a("north");
	public static final PropertyBool EAST = PropertyBool.func_177716_a("east");
	public static final PropertyBool SOUTH = PropertyBool.func_177716_a("south");
	public static final PropertyBool WEST = PropertyBool.func_177716_a("west");
	public static final AxisAlignedBB PILLAR_AABB = new AxisAlignedBB(0.375D, 0.0D, 0.375D, 0.625D, 1D, 0.625D);
	public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375D, 0.0D, 0.625D, 0.625D, 1D, 1.0D);
	public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0D, 0.0D, 0.375D, 0.375D, 1D, 0.625D);
	public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375D, 0.0D, 0.0D, 0.625D, 1D, 0.375D);
	public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.625D, 0.0D, 0.375D, 1.0D, 1D, 0.625D);
	protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{
		new AxisAlignedBB(0.375D, 0.0D, 0.375D, 0.625D, 1.0D, 0.625D),
		new AxisAlignedBB(0.375D, 0.0D, 0.375D, 0.625D, 1.0D, 1.0D),
		new AxisAlignedBB(0.0D, 0.0D, 0.375D, 0.625D, 1.0D, 0.625D),
		new AxisAlignedBB(0.0D, 0.0D, 0.375D, 0.625D, 1.0D, 1.0D),
		new AxisAlignedBB(0.375D, 0.0D, 0.0D, 0.625D, 1.0D, 0.625D),
		new AxisAlignedBB(0.375D, 0.0D, 0.0D, 0.625D, 1.0D, 1.0D),
		new AxisAlignedBB(0.0D, 0.0D, 0.0D, 0.625D, 1.0D, 0.625D),
		new AxisAlignedBB(0.0D, 0.0D, 0.0D, 0.625D, 1.0D, 1.0D),
		new AxisAlignedBB(0.375D, 0.0D, 0.375D, 1.0D, 1.0D, 0.625D),
		new AxisAlignedBB(0.375D, 0.0D, 0.375D, 1.0D, 1.0D, 1.0D),
		new AxisAlignedBB(0.0D, 0.0D, 0.375D, 1.0D, 1.0D, 0.625D),
		new AxisAlignedBB(0.0D, 0.0D, 0.375D, 1.0D, 1.0D, 1.0D),
		new AxisAlignedBB(0.375D, 0.0D, 0.0D, 1.0D, 1.0D, 0.625D),
		new AxisAlignedBB(0.375D, 0.0D, 0.0D, 1.0D, 1.0D, 1.0D),
		new AxisAlignedBB(0.0D, 0.0D, 0.0D, 1.0D, 1.0D, 0.625D),
		new AxisAlignedBB(0.0D, 0.0D, 0.0D, 1.0D, 1.0D, 1.0D)
	};

	public BlockShrubLog() {
		super(Material.field_151575_d);
		this.func_180632_j(this.field_176227_L.func_177621_b()
			.func_177226_a(NORTH, false)
			.func_177226_a(EAST, false)
			.func_177226_a(SOUTH, false)
			.func_177226_a(WEST, false)
			.func_177226_a(FIREPROOF, false));
		setRegistryName(new ResourceLocation(Constants.EXTRA_TREES_MOD_ID, "shrub_log"));
		func_149663_c("shrub_log");
		func_149672_a(SoundType.field_185848_a);
		func_149711_c(EnumShrubLog.INSTANCE.getHardness());
	}

	private static int getBoundingBoxIdx(IBlockState state) {
		int i = 0;

		if (state.func_177229_b(NORTH)) {
			i |= 1 << EnumFacing.NORTH.func_176736_b();
		}

		if (state.func_177229_b(EAST)) {
			i |= 1 << EnumFacing.EAST.func_176736_b();
		}

		if (state.func_177229_b(SOUTH)) {
			i |= 1 << EnumFacing.SOUTH.func_176736_b();
		}

		if (state.func_177229_b(WEST)) {
			i |= 1 << EnumFacing.WEST.func_176736_b();
		}

		return i;
	}

	@Override
	public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox,
	                                  List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
		if (!p_185477_7_) {
			state = state.func_185899_b(worldIn, pos);
		}

		func_185492_a(pos, entityBox, collidingBoxes, PILLAR_AABB);

		if (state.func_177229_b(NORTH)) {
			func_185492_a(pos, entityBox, collidingBoxes, NORTH_AABB);
		}

		if (state.func_177229_b(EAST)) {
			func_185492_a(pos, entityBox, collidingBoxes, EAST_AABB);
		}

		if (state.func_177229_b(SOUTH)) {
			func_185492_a(pos, entityBox, collidingBoxes, SOUTH_AABB);
		}

		if (state.func_177229_b(WEST)) {
			func_185492_a(pos, entityBox, collidingBoxes, WEST_AABB);
		}
	}

	@Override
	public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
		state = this.func_176221_a(state, source, pos);
		return BOUNDING_BOXES[getBoundingBoxIdx(state)];
	}

	@Override
	public boolean func_149662_c(IBlockState state) {
		return false;
	}

	@Override
	public boolean func_149686_d(IBlockState state) {
		return false;
	}

	@Override
	public final int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
		IBlockState state = world.func_180495_p(pos);
		if (state.func_177229_b(FIREPROOF)) {
			return 0;
		} else if (face == EnumFacing.DOWN) {
			return 20;
		} else if (face != EnumFacing.UP) {
			return 10;
		} else {
			return 5;
		}
	}

	@Override
	public final int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
		IBlockState state = world.func_180495_p(pos);
		if (state.func_177229_b(FIREPROOF)) {
			return 0;
		}
		return 5;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos,
	                                    EnumFacing side) {
		return true;
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(FIREPROOF) ? 1 : 0;
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(FIREPROOF, meta == 1);
	}

	@Override
	public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
		return state.func_177226_a(NORTH, canFenceConnectTo(worldIn, pos, EnumFacing.NORTH))
			.func_177226_a(EAST, canFenceConnectTo(worldIn, pos, EnumFacing.EAST))
			.func_177226_a(SOUTH, canFenceConnectTo(worldIn, pos, EnumFacing.SOUTH))
			.func_177226_a(WEST, canFenceConnectTo(worldIn, pos, EnumFacing.WEST));
	}

	private boolean canFenceConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
		IBlockState blockState = world.func_180495_p(pos.func_177972_a(facing));
		Block block = blockState.func_177230_c();
		return block.isLeaves(blockState, world, pos) || block == this;
	}

	@Override
	public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
		Random rand = world instanceof World ? ((World) world).field_73012_v : RANDOM;
		List<ItemStack> ret = new java.util.ArrayList<>();
		float chance = 0.75F;
		int amount = 2;
		while (chance >= rand.nextFloat()) {
			chance -= 0.25;
			amount++;
		}
		ret.add(new ItemStack(Items.field_151055_y, amount));
		return ret;
	}

	@Override
	public boolean isWood(IBlockAccess world, BlockPos pos) {
		return true;
	}

	@Override
	public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
		return true;
	}

	@Override
	public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
		int i = 4;
		int j = 5;

		if (worldIn.func_175707_a(pos.func_177982_a(-5, -5, -5), pos.func_177982_a(5, 5, 5))) {
			for (BlockPos blockpos : BlockPos.func_177980_a(pos.func_177982_a(-4, -4, -4), pos.func_177982_a(4, 4, 4))) {
				IBlockState iblockstate = worldIn.func_180495_p(blockpos);

				if (iblockstate.func_177230_c().isLeaves(iblockstate, worldIn, blockpos)) {
					iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
				}
			}
		}
	}

	@Override
	public IBlockState func_185499_a(IBlockState state, Rotation rot) {
		switch (rot) {
			case CLOCKWISE_180:
				return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(EAST, state.func_177229_b(WEST))
					.func_177226_a(SOUTH, state.func_177229_b(NORTH)).func_177226_a(WEST, state.func_177229_b(EAST));
			case COUNTERCLOCKWISE_90:
				return state.func_177226_a(NORTH, state.func_177229_b(EAST)).func_177226_a(EAST, state.func_177229_b(SOUTH))
					.func_177226_a(SOUTH, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(NORTH));
			case CLOCKWISE_90:
				return state.func_177226_a(NORTH, state.func_177229_b(WEST)).func_177226_a(EAST, state.func_177229_b(NORTH))
					.func_177226_a(SOUTH, state.func_177229_b(EAST)).func_177226_a(WEST, state.func_177229_b(SOUTH));
			default:
				return state;
		}
	}

	@Override
	public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
		switch (mirrorIn) {
			case LEFT_RIGHT:
				return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(SOUTH, state.func_177229_b(NORTH));
			case FRONT_BACK:
				return state.func_177226_a(EAST, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(EAST));
			default:
				return super.func_185471_a(state, mirrorIn);
		}
	}

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, NORTH, EAST, WEST, SOUTH, FIREPROOF);
	}

	@Override
	public WoodBlockKind getBlockKind() {
		return WoodBlockKind.LOG;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerStateMapper() {
		ModelLoader.setCustomStateMapper(this, new StateMap.Builder().func_178442_a(FIREPROOF).func_178441_a());
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		manager.registerItemModel(item, 0, "shrub_trunk");
		manager.registerItemModel(item, 1, "shrub_trunk");
	}

	//TODO: Add meta to forestry api
	@Override
	public boolean isFireproof() {
		return false;
	}

	@Override
	public IWoodType getWoodType(int meta) {
		return EnumShrubLog.INSTANCE;
	}

	@Override
	public Collection<? extends IWoodType> getWoodTypes() {
		return Collections.singletonList(EnumShrubLog.INSTANCE);
	}
}
