/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.isolator;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.isolator.IsolaterFX;
import binnie.genetics.machine.isolator.Isolator;
import binnie.genetics.machine.isolator.IsolatorLogic;
import forestry.core.fluids.Fluids;
import java.util.Objects;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class PackageIsolator
extends GeneticMachine.PackageGeneticBase
implements IMachineInformation {
    public PackageIsolator() {
        super("isolator", GeneticsTexture.ISOLATOR, 0xFF6F0F, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.ISOLATOR);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot slotEnzyme = inventory.addSlot(0, "enzyme");
        slotEnzyme.setValidator(new SlotValidator.Item(GeneticsItems.Enzyme.get(1), ModuleMachine.spriteEnzyme));
        slotEnzyme.forbidExtraction();
        InventorySlot slotSequencer = inventory.addSlot(1, "sequencervial");
        slotSequencer.setValidator(new SlotValidator.Item(GeneticsItems.EmptySequencer.get(1), ModuleMachine.spriteSequencer));
        slotSequencer.forbidExtraction();
        for (InventorySlot slot : inventory.addSlotArray(Isolator.SLOT_RESERVE, "input")) {
            slot.setValidator(new SlotValidator.Individual());
            slot.forbidExtraction();
        }
        InventorySlot slotTarget = inventory.addSlot(5, "process");
        slotTarget.setValidator(new SlotValidator.Individual());
        slotTarget.setReadOnly();
        slotTarget.forbidInteraction();
        InventorySlot slotResulut = inventory.addSlot(6, "output");
        slotResulut.setReadOnly();
        slotResulut.forbidInteraction();
        for (InventorySlot slot : inventory.addSlotArray(Isolator.SLOT_FINISHED, "output")) {
            slot.setReadOnly();
            slot.forbidInsertion();
        }
        ComponentTankContainer tanks = new ComponentTankContainer(machine);
        tanks.addTank(0, "input", 1000).setValidator(new TankValidator(){

            @Override
            public String getTooltip() {
                return FluidRegistry.getFluidStack((String)Fluids.BIO_ETHANOL.getTag(), (int)1).getLocalizedName();
            }

            @Override
            public boolean isValid(FluidStack stack) {
                return Objects.equals(stack.getFluid().getName(), Fluids.BIO_ETHANOL.getTag());
            }
        });
        ComponentChargedSlots chargedSlots = new ComponentChargedSlots(machine);
        chargedSlots.addCharge(0);
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Isolator.SLOT_RESERVE, 5, 1);
        transfer.addStorage(6, Isolator.SLOT_FINISHED);
        new ComponentPowerReceptor(machine, 20000);
        new IsolatorLogic(machine);
        new IsolaterFX(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }

    @Override
    public void register() {
    }
}

