/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.acclimatiser;

import binnie.core.machines.IMachine;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateDefinition;
import binnie.genetics.machine.GeneticsErrorCode;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class AcclimatiserLogic
extends ComponentProcessIndefinate {
    public AcclimatiserLogic(IMachine machine) {
        super(machine, 2.0f);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().getStack(4).func_190926_b()) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.NO_INDIVIDUAL, 4);
        }
        if (this.getUtil().getNonEmptyStacks(Acclimatiser.SLOT_ACCLIMATISER).isEmpty()) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ACCLIMATISER_NO_ITEM, Acclimatiser.SLOT_ACCLIMATISER);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (!Acclimatiser.canAcclimatise(this.getUtil().getStack(4), this.getUtil().getNonEmptyStacks(Acclimatiser.SLOT_ACCLIMATISER))) {
            return new ErrorState((IErrorStateDefinition)GeneticsErrorCode.ACCLIMATISER_CAN_NOT_WORK, 4);
        }
        return super.canProgress();
    }

    @Override
    protected boolean inProgress() {
        return this.canWork() == null;
    }

    @Override
    protected void onTickTask() {
        super.onTickTask();
        if (this.getUtil().getRandom().nextInt(100) == 0) {
            this.attemptAcclimatisation();
        }
    }

    protected void attemptAcclimatisation() {
        ArrayList<ItemStack> acclms = new ArrayList<ItemStack>();
        ItemStack target = this.getUtil().getStack(4);
        if (target.func_190926_b()) {
            return;
        }
        for (ItemStack s : this.getUtil().getNonEmptyStacks(Acclimatiser.SLOT_ACCLIMATISER)) {
            if (!Acclimatiser.canAcclimatise(target, s)) continue;
            acclms.add(s);
        }
        ItemStack acc = (ItemStack)acclms.get(this.getUtil().getRandom().nextInt(acclms.size()));
        ItemStack acclimed = Acclimatiser.acclimatise(target, acc);
        this.getUtil().setStack(4, acclimed);
        for (int i : Acclimatiser.SLOT_ACCLIMATISER) {
            ItemStack stack = this.getUtil().getStack(i);
            if (stack.func_190926_b() || !stack.func_77969_a(acc)) continue;
            this.getUtil().decreaseStack(i, 1);
            break;
        }
    }
}

