/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.integration.jei.isolator;

import binnie.core.genetics.Gene;
import binnie.genetics.integration.jei.isolator.IsolatorRecipeWrapper;
import binnie.genetics.item.ItemSequence;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;

public class IsolatorRecipeMaker {
    public static List<IsolatorRecipeWrapper> create() {
        ArrayList<IsolatorRecipeWrapper> recipes = new ArrayList<IsolatorRecipeWrapper>();
        Collection roots = AlleleManager.alleleRegistry.getSpeciesRoot().values();
        for (ISpeciesRoot root : roots) {
            ISpeciesType[] speciesTypes = (ISpeciesType[])root.getIconType().getClass().getEnumConstants();
            IChromosomeType speciesChromosomeType = root.getSpeciesChromosomeType();
            IAllele[] defaultTemplate = root.getDefaultTemplate();
            IIndividual individual = root.templateAsIndividual(defaultTemplate);
            for (ISpeciesType speciesType : speciesTypes) {
                ItemStack memberStack = root.getMemberStack(individual, speciesType);
                memberStack.func_77964_b(Short.MAX_VALUE);
                IAllele species = defaultTemplate[speciesChromosomeType.ordinal()];
                ItemStack filledSequence = ItemSequence.create(new Gene(species, speciesChromosomeType, root), false);
                IsolatorRecipeWrapper recipeWrapper = new IsolatorRecipeWrapper(memberStack, filledSequence);
                recipes.add(recipeWrapper);
            }
        }
        return recipes;
    }
}

