/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block.wood;

import binnie.extratrees.block.EnumETLog;
import binnie.extratrees.block.property.PropertyETWoodType;
import forestry.arboriculture.blocks.BlockForestryPlanks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public abstract class BlockETPlank
extends BlockForestryPlanks<EnumETLog> {
    public static final String BLOCK_NAME = "plank";

    private BlockETPlank(boolean fireproof, int blockNumber) {
        super(fireproof, blockNumber);
        String name = "planks.";
        if (fireproof) {
            name = name + "fireproof.";
        }
        name = name + blockNumber;
        this.setRegistryName(new ResourceLocation("extratrees", name));
        this.func_149663_c(name);
    }

    public static List<BlockETPlank> create(boolean fireproof) {
        ArrayList<BlockETPlank> blocks = new ArrayList<BlockETPlank>();
        PropertyETWoodType[] variants = PropertyETWoodType.create("variant", 16, false);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyETWoodType variant = variants[i];
            BlockETPlank block = new BlockETPlank(fireproof, i){

                public PropertyETWoodType getVariant() {
                    return variant;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    public EnumETLog getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = meta % variantCount + this.getBlockNumber() * 16;
        return EnumETLog.byMetadata(variantMeta);
    }
}

