package binnie.genetics.integration.jei.polymeriser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import net.minecraft.item.ItemStack;

import net.minecraftforge.oredict.OreDictionary;

import binnie.genetics.Genetics;
import binnie.genetics.integration.jei.GeneticsJeiPlugin;
import mezz.jei.api.recipe.IStackHelper;

public class PolymeriserRecipeMaker {
	public static List<PolymeriserRecipeWrapper> create() {
		List<PolymeriserRecipeWrapper> recipes = new ArrayList<>();

		List<ItemStack> inputs = Arrays.asList(
			new ItemStack(Genetics.items().itemSequencer, 1, OreDictionary.WILDCARD_VALUE),
			new ItemStack(Genetics.items().itemSerum, 1, OreDictionary.WILDCARD_VALUE),
			new ItemStack(Genetics.items().itemSerumArray, 1, OreDictionary.WILDCARD_VALUE)
		);

		IStackHelper stackHelper = GeneticsJeiPlugin.jeiHelpers.getStackHelper();
		for (ItemStack input : inputs) {
			List<ItemStack> subtypes = stackHelper.toItemStackList(input);
			for (ItemStack subtype : subtypes) {
				subtype = subtype.func_77946_l();
				subtype.func_77964_b(subtype.func_77958_k());
				recipes.add(new PolymeriserRecipeWrapper(subtype));
			}
		}

		return recipes;
	}
}
