package binnie.core.machines.storage;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;

import binnie.core.craftgui.minecraft.EnumColor;

class CompartmentTab implements INbtWritable, INbtReadable {
	private String name;
	private ItemStack icon;
	private EnumColor color;
	private int id;

	public CompartmentTab(final int id) {
		this.name = "";
		this.icon = new ItemStack(Items.field_151121_aF);
		this.color = EnumColor.White;
		this.id = id;
	}

	@Override
	public void readFromNBT(final NBTTagCompound nbt) {
		this.name = nbt.func_74779_i("name");
		this.icon = new ItemStack(nbt.func_74775_l("icon"));
		this.color = EnumColor.values()[nbt.func_74771_c("color")];
		this.id = nbt.func_74771_c("id");
	}

	@Override
	public NBTTagCompound writeToNBT(final NBTTagCompound nbt) {
		nbt.func_74778_a("name", this.name);
		final NBTTagCompound n = new NBTTagCompound();
		this.icon.func_77955_b(n);
		nbt.func_74782_a("icon", n);
		nbt.func_74774_a("color", (byte) this.color.ordinal());
		nbt.func_74774_a("id", (byte) this.id);
		return nbt;
	}

	public String getName() {
		return this.name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public ItemStack getIcon() {
		return this.icon;
	}

	public void setIcon(final ItemStack icon) {
		this.icon = icon;
	}

	public EnumColor getColor() {
		return this.color;
	}

	public void setColor(final EnumColor color) {
		this.color = color;
	}

	public int getId() {
		return this.id;
	}
}
