/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.brewery.recipes;

import binnie.extratrees.api.recipes.IBreweryManager;
import binnie.extratrees.api.recipes.IBreweryRecipe;
import binnie.extratrees.integration.jei.brewery.BreweryRecipeWrapper;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.machines.brewery.recipes.BrewedGrainRecipe;
import binnie.extratrees.machines.brewery.recipes.BreweryCrafting;
import binnie.extratrees.machines.brewery.recipes.BreweryRecipe;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public class BreweryRecipeManager
implements IBreweryManager {
    private static Set<IBreweryRecipe> recipes = new HashSet<IBreweryRecipe>();

    public static boolean isValidGrain(ItemStack itemstack) {
        for (IBreweryRecipe recipe : recipes) {
            if (!recipe.isGrain(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidYeast(ItemStack itemstack) {
        for (IBreweryRecipe recipe : recipes) {
            ItemStack yeast = recipe.getYeast();
            if (!yeast.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FluidStack getOutput(FluidStack stack) {
        BreweryCrafting crafting = new BreweryCrafting(stack, ItemStack.field_190927_a, null, ItemStack.field_190927_a);
        for (IBreweryRecipe recipe : recipes) {
            FluidStack output = recipe.getOutput(crafting);
            if (output == null) continue;
            return output;
        }
        return null;
    }

    @Nullable
    public static FluidStack getOutput(BreweryCrafting crafting) {
        if (crafting.inputFluid != null && !crafting.yeast.func_190926_b()) {
            for (IBreweryRecipe recipe : recipes) {
                FluidStack output = recipe.getOutput(crafting);
                if (output == null) continue;
                return output;
            }
        }
        return null;
    }

    @Nullable
    public static IBreweryRecipe getRecipe(BreweryCrafting crafting) {
        if (crafting.inputFluid != null && !crafting.yeast.func_190926_b()) {
            for (IBreweryRecipe recipe : recipes) {
                FluidStack output = recipe.getOutput(crafting);
                if (output == null) continue;
                return recipe;
            }
        }
        return null;
    }

    public static boolean isValidIngredient(ItemStack itemstack) {
        for (IBreweryRecipe recipe : recipes) {
            if (!recipe.isIngredient(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInputLiquid(FluidStack fluid) {
        for (IBreweryRecipe recipe : recipes) {
            FluidStack input = recipe.getInput();
            if (!input.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidOutputLiquid(FluidStack fluid) {
        for (IBreweryRecipe recipe : recipes) {
            FluidStack output = recipe.getOutput();
            if (!output.isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addRecipe(FluidStack input, FluidStack output) {
        this.addRecipe(input, output, ExtraTreeItems.Yeast.get(1));
    }

    @Override
    public void addRecipe(FluidStack input, FluidStack output, ItemStack yeast) {
        recipes.add(new BreweryRecipe(input, output, yeast));
    }

    @Override
    public void addGrainRecipe(String grainOreName, FluidStack output) {
        this.addGrainRecipe(grainOreName, output, null);
    }

    @Override
    public void addGrainRecipe(String grainOreName, FluidStack output, @Nullable String ingredientOreName) {
        this.addGrainRecipe(grainOreName, output, ingredientOreName, ExtraTreeItems.Yeast.get(1));
    }

    @Override
    public void addGrainRecipe(String grainOreName, FluidStack output, @Nullable String ingredientOreName, ItemStack yeast) {
        recipes.add(new BrewedGrainRecipe(output, grainOreName, ingredientOreName, yeast));
    }

    @Override
    public boolean addRecipe(IBreweryRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(IBreweryRecipe recipe) {
        return recipes.remove(recipe);
    }

    @Override
    public Collection<IBreweryRecipe> recipes() {
        return recipes;
    }

    public String toString() {
        return "Brewery";
    }

    @Override
    public String getJEICategory() {
        return "binnie.extratrees.brewing";
    }

    @Override
    @Nullable
    public Object getJeiWrapper(IBreweryRecipe recipe) {
        if (!Loader.isModLoaded((String)"jei")) {
            return null;
        }
        return this.getWrapper(recipe);
    }

    @Optional.Method(modid="jei")
    private Object getWrapper(IBreweryRecipe recipe) {
        return new BreweryRecipeWrapper(recipe);
    }
}

