/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network;

import binnie.core.BinnieCore;
import binnie.core.block.TileEntityMetadata;
import binnie.core.gui.minecraft.ContainerCraftGUI;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.IPacketID;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageCraftGUI;
import binnie.core.network.packet.MessageMetadata;
import binnie.core.network.packet.MessageSyncTile;
import binnie.core.network.packet.MessageUpdate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public enum BinnieCorePacketID implements IPacketID
{
    NETWORK_ENTITY_UPDATE,
    TILE_METADATA,
    CRAFT_GUI_ACTION,
    TILE_DESCRIPTION_SYNC;


    @Override
    public void onMessage(MessageBinnie message, MessageContext context) {
        IMachine machine;
        MessageSyncTile packet4;
        TileEntity tile;
        if (this == NETWORK_ENTITY_UPDATE) {
            MessageUpdate packet = new MessageUpdate(message);
            TileEntity tile2 = packet.getTileEntity(BinnieCore.getBinnieProxy().getWorld());
            if (tile2 instanceof INetworkedEntity) {
                ((INetworkedEntity)tile2).readFromPacket(packet.payload);
            }
        } else if (this == TILE_METADATA) {
            MessageMetadata packet2 = new MessageMetadata(message);
            TileEntity tile3 = packet2.getTileEntity(BinnieCore.getBinnieProxy().getWorld());
            if (tile3 instanceof TileEntityMetadata) {
                ((TileEntityMetadata)tile3).setTileMetadata(packet2.meta, true);
            }
        } else if (this == CRAFT_GUI_ACTION && context.side == Side.CLIENT) {
            MessageCraftGUI packet3 = new MessageCraftGUI(message);
            EntityPlayer player = BinnieCore.getBinnieProxy().getPlayer();
            if (player.field_71070_bA instanceof ContainerCraftGUI && packet3.getTagCompound() != null) {
                ((ContainerCraftGUI)player.field_71070_bA).receiveNBTClient(player, packet3.getTagCompound());
            }
        } else if (this == CRAFT_GUI_ACTION && context.side == Side.SERVER && context.netHandler instanceof NetHandlerPlayServer) {
            MessageCraftGUI packet3 = new MessageCraftGUI(message);
            EntityPlayerMP player = ((NetHandlerPlayServer)context.netHandler).field_147369_b;
            if (player.field_71070_bA instanceof ContainerCraftGUI && packet3.getTagCompound() != null) {
                ((ContainerCraftGUI)player.field_71070_bA).receiveNBTServer((EntityPlayer)player, packet3.getTagCompound());
            }
        } else if (this == TILE_DESCRIPTION_SYNC && context.side == Side.CLIENT && (tile = (packet4 = new MessageSyncTile(message)).getTarget(BinnieCore.getBinnieProxy().getWorld())) != null && packet4.getTagCompound() != null && (machine = Machine.getMachine(tile)) != null && machine instanceof INetwork.TilePacketSync) {
            ((INetwork.TilePacketSync)((Object)machine)).syncFromNBT(packet4.getTagCompound());
        }
    }
}

