/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gui.database;

import binnie.botany.api.genetics.IFlowerColor;
import binnie.core.gui.Attribute;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.renderer.RenderUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlColorDisplay
extends Control
implements IControlValue<IFlowerColor>,
ITooltip {
    private IFlowerColor value;

    public ControlColorDisplay(IWidget parent, int x, int y, IFlowerColor value) {
        super(parent, x, y, 16, 16);
        this.value = value;
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Override
    public IFlowerColor getValue() {
        return this.value;
    }

    @Override
    public void setValue(IFlowerColor value) {
        this.value = value;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        RenderUtil.drawSolidRect(this.getArea(), -1);
        RenderUtil.drawSolidRect(this.getArea().inset(1), -16777216 + this.getValue().getColor(false));
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        super.getTooltip(tooltip);
        tooltip.add(this.value.getColorName());
    }
}

