package binnie.botany.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.modules.ModuleCeramic;

public class TileCeramic extends TileEntity {
	protected EnumFlowerColor color = EnumFlowerColor.Black;

	public EnumFlowerColor getColor() {
		return color;
	}

	public void setColor(EnumFlowerColor color) {
		this.color = color;
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound compound) {
		compound.func_74768_a("Color", color.getFlowerColorAllele().getID());
		return super.func_189515_b(compound);
	}

	@Override
	public void func_145839_a(NBTTagCompound compound) {
		super.func_145839_a(compound);
		color = EnumFlowerColor.VALUES[compound.func_74762_e("Color")];
	}

	public ItemStack getStack() {
		return getStack(1);
	}

	public ItemStack getStack(int amount) {
		int ID = 0;
		if (color != null) {
			ID = color.getFlowerColorAllele().getID();
		}
		return new ItemStack(ModuleCeramic.ceramic, amount, ID);
	}
}
