package binnie.botany.recipes;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

import net.minecraftforge.common.ForgeHooks;

import binnie.Binnie;
import binnie.botany.api.genetics.IFlower;
import binnie.botany.modules.ModuleCeramic;

public class PigmentRecipe implements IRecipe {
	@Override
	public boolean func_77569_a(InventoryCrafting crafting, World world) {
		return !func_77572_b(crafting).func_190926_b();
	}

	@Override
	public ItemStack func_77571_b() {
		return ItemStack.field_190927_a;
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting crafting) {
		int n = 0;
		ItemStack stack = ItemStack.field_190927_a;
		for (int i = 0; i < crafting.func_70302_i_(); ++i) {
			ItemStack stackInSlot = crafting.func_70301_a(i);
			if (!stackInSlot.func_190926_b()) {
				if (++n > 1) {
					return ItemStack.field_190927_a;
				}
				if (Binnie.GENETICS.getFlowerRoot().isMember(stackInSlot)) {
					IFlower flower = Binnie.GENETICS.getFlowerRoot().getMember(stackInSlot);
					if (flower != null && flower.getAge() >= 1) {
						stack = new ItemStack(ModuleCeramic.pigment, 1, flower.getGenome().getPrimaryColor().getID());
					}
				}
			}
		}
		return stack;
	}

	@Override
	public int func_77570_a() {
		return 1;
	}

	@Override
	public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
		return ForgeHooks.defaultRecipeGetRemainingItems(inv);
	}
}
