package binnie.botany.items;

import java.util.List;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.botany.api.gardening.EnumSoilType;
import binnie.botany.blocks.BlockSoil;
import binnie.core.util.I18N;

public class ItemSoil extends ItemBlock {
	private final EnumSoilType type;
	private final boolean noWeed;

	public ItemSoil(BlockSoil block) {
		super(block);
		type = block.getType();
		noWeed = block.isWeedKilled();
		field_77787_bX = true;
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
		StringBuilder builder = new StringBuilder();
		builder.append(BlockSoil.getMoisture(stack, true, true));

		String phInfo =  BlockSoil.getPH(stack, true, true);
		if (phInfo.length() > 0) {
			if(builder.length() > 0){
				builder.append(", ");
			}
			builder.append(phInfo);
		}
		if(builder.length() > 0){
			tooltip.add(builder.toString());
		}

		if (noWeed) {
			tooltip.add(TextFormatting.GREEN + I18N.localise("botany.soil.weedkiller"));
		}
	}

	@Override
	public String func_77653_i(ItemStack stack) {
		return func_77657_g(stack).trim();
	}

	@Override
	public int func_77647_b(int damage) {
		return damage;
	}
}
