/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.gui.IBinnieGUID;
import binnie.core.machines.errors.ErrorStateRegistry;
import binnie.core.network.BinniePacketHandler;
import binnie.core.network.IPacketID;
import binnie.core.proxy.IProxyCore;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsPacket;
import binnie.genetics.item.ItemBeeDictionary;
import binnie.genetics.item.ItemPunnettSquare;
import binnie.genetics.item.ModuleItems;
import binnie.genetics.machine.GeneticsErrorCode;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.proxy.Proxy;
import com.google.common.base.Preconditions;
import forestry.api.recipes.RecipeManagers;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="genetics", name="Binnie's Genetics", dependencies="required-after:binniecore", acceptedMinecraftVersions="[1.11.2]")
public class Genetics
extends AbstractMod {
    public static final String CHANNEL = "GEN";
    @Mod.Instance(value="genetics")
    public static Genetics instance;
    @SidedProxy(clientSide="binnie.genetics.proxy.ProxyClient", serverSide="binnie.genetics.proxy.ProxyServer")
    public static Proxy proxy;
    @Nullable
    private static ModuleItems items;
    @Nullable
    private static ModuleMachine machine;
    private static Item dictionaryBees;

    public static ModuleItems items() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    public static ModuleMachine machine() {
        Preconditions.checkState((machine != null ? 1 : 0) != 0);
        return machine;
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        dictionaryBees = proxy.registerItem(new ItemBeeDictionary());
        proxy.registerItem(new ItemPunnettSquare());
        super.preInit(evt);
        for (GeneticsErrorCode errorCode : GeneticsErrorCode.values()) {
            ErrorStateRegistry.registerErrorState(errorCode);
        }
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        super.postInit(evt);
        RecipeManagers.carpenterManager.addRecipe(100, Binnie.LIQUID.getFluidStack("water", 2000), ItemStack.field_190927_a, new ItemStack(dictionaryBees), new Object[]{"X#X", "YEY", "RDR", Character.valueOf('#'), Blocks.field_150410_aZ, Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), "ingotTin", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('E'), Items.field_151166_bC});
    }

    @Override
    protected void registerModules() {
        items = new ModuleItems();
        this.addModule(items);
        machine = new ModuleMachine();
        this.addModule(machine);
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return GeneticsGUI.values();
    }

    @Override
    public IPacketID[] getPacketIDs() {
        return GeneticsPacket.values();
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }

    @Override
    public IProxyCore getProxy() {
        return proxy;
    }

    @Override
    public String getModID() {
        return "genetics";
    }

    @Override
    protected Class<? extends BinniePacketHandler> getPacketHandler() {
        return PacketHandler.class;
    }

    @Override
    public boolean isAvailable() {
        return BinnieCore.isGeneticsActive();
    }

    public static class PacketHandler
    extends BinniePacketHandler {
        public PacketHandler() {
            super(instance);
        }
    }
}

