/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.genetics;

import binnie.botany.api.genetics.EnumFlowerStage;
import binnie.botany.api.genetics.IFlowerType;
import forestry.api.core.IModelManager;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumFlowerType implements IFlowerType<EnumFlowerType>
{
    DANDELION,
    POPPY,
    ORCHID,
    ALLIUM,
    BLUET,
    TULIP,
    DAISY,
    CORNFLOWER,
    PANSY,
    IRIS,
    LAVENDER(2),
    VIOLA,
    DAFFODIL,
    DAHLIA,
    PEONY(2),
    ROSE(2),
    LILAC(2),
    HYDRANGEA(2),
    FOXGLOVE(2),
    ZINNIA,
    MUMS,
    MARIGOLD,
    GERANIUM,
    AZALEA,
    PRIMROSE,
    ASTER,
    CARNATION,
    LILY,
    YARROW,
    Petunia,
    AGAPANTHUS,
    FUCHSIA,
    DIANTHUS,
    FORGET,
    ANEMONE,
    AQUILEGIA,
    EDELWEISS,
    SCABIOUS,
    CONEFLOWER,
    GAILLARDIA,
    AURICULA,
    CAMELLIA(2),
    GOLDENROD(2),
    ALTHEA(2),
    PENSTEMON(2),
    DELPHINIUM(2),
    HOLLYHOCK(2);

    public static EnumFlowerType[] VALUES;
    public static int highestSection;
    int sections;
    ModelResourceLocation flower;
    ModelResourceLocation seed;
    ModelResourceLocation pollen;

    private EnumFlowerType() {
        this(1);
    }

    private EnumFlowerType(int sections) {
        this.sections = sections;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(Item item, IModelManager manager, EnumFlowerStage type) {
        String pre = this.sections == 1 ? "" : "double/";
        this.flower = new ModelResourceLocation("botany:flowers/" + pre + this.getName(), "inventory");
        this.seed = new ModelResourceLocation("botany:flowers/seed", "inventory");
        this.pollen = new ModelResourceLocation("botany:flowers/pollen", "inventory");
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{this.pollen, this.seed, this.flower});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(EnumFlowerStage type, boolean flowered) {
        if (type == EnumFlowerStage.SEED) {
            return this.seed;
        }
        if (type == EnumFlowerStage.POLLEN) {
            return this.pollen;
        }
        return this.flower;
    }

    @Override
    public int getID() {
        return this.ordinal();
    }

    @Override
    public int getSections() {
        return this.sections;
    }

    @Override
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        VALUES = EnumFlowerType.values();
        highestSection = 2;
    }
}

