/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.ceramic.brick;

import binnie.botany.ceramic.brick.CeramicBrickPair;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.items.CeramicItems;
import binnie.botany.modules.ModuleCeramic;
import binnie.core.block.TileEntityMetadata;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum CeramicBrickType implements IStringSerializable
{
    TILE("tile"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            if (stacks.size() != 4) {
                return ItemStack.field_190927_a;
            }
            int mortars = 0;
            int blocks = 0;
            int blockColor = -1;
            for (ItemStack stack : stacks) {
                if (this.isMortar(stack)) {
                    ++mortars;
                    continue;
                }
                if (stack.func_77973_b() != Item.func_150898_a((Block)ModuleCeramic.ceramic)) {
                    return ItemStack.field_190927_a;
                }
                ++blocks;
                int color = TileEntityMetadata.getItemDamage(stack);
                if (blockColor == -1) {
                    blockColor = color;
                    continue;
                }
                if (blockColor == color) continue;
                return ItemStack.field_190927_a;
            }
            if (mortars != 1) {
                return ItemStack.field_190927_a;
            }
            EnumFlowerColor c = EnumFlowerColor.get(blockColor);
            return new CeramicBrickPair(c, c, TILE).getStack(3);
        }
    }
    ,
    BRICK("brick"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            return this.getBrickRecipe(this, stacks);
        }
    }
    ,
    STRIPE_BRICK("brickstripe"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            return this.getBrickRecipe(this, stacks);
        }
    }
    ,
    LARGE_BRICK("bricklarge"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            if (stacks.size() == 1) {
                ItemStack stack3 = stacks.get(0);
                CeramicBrickPair type3 = new CeramicBrickPair(stack3);
                if (type3.type == VERTICAL_LARGE_BRICK) {
                    type3.type = this;
                    return type3.getStack(1);
                }
                return ItemStack.field_190927_a;
            }
            if (stacks.size() != 3) {
                return ItemStack.field_190927_a;
            }
            int[] colors = new int[]{-1, -1};
            int a = 0;
            int b = 0;
            for (ItemStack stack4 : stacks) {
                if (stack4.func_77973_b() != Item.func_150898_a((Block)ModuleCeramic.ceramicBrick)) {
                    return ItemStack.field_190927_a;
                }
                CeramicBrickPair type4 = new CeramicBrickPair(stack4);
                if (type4.type != TILE) {
                    return ItemStack.field_190927_a;
                }
                int color5 = type4.colorFirst.ordinal();
                if (colors[0] == -1) {
                    colors[0] = color5;
                    ++a;
                    continue;
                }
                if (colors[0] == color5) {
                    ++a;
                    continue;
                }
                if (colors[1] == -1) {
                    colors[1] = color5;
                    ++b;
                    continue;
                }
                if (colors[1] != color5) {
                    return ItemStack.field_190927_a;
                }
                ++b;
            }
            if (colors[1] == -1) {
                colors[1] = colors[0];
            }
            return new CeramicBrickPair(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), LARGE_BRICK).getStack(3);
        }
    }
    ,
    SPLIT("split"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            if (stacks.size() != 4) {
                return ItemStack.field_190927_a;
            }
            int[] colors = new int[]{-1, -1};
            int altCounter = 0;
            for (ItemStack stack2 : stacks) {
                int alt;
                int n = alt = altCounter != 0 && altCounter != 3 ? 1 : 0;
                if (stack2.func_77973_b() != Item.func_150898_a((Block)ModuleCeramic.ceramicBrick)) {
                    return ItemStack.field_190927_a;
                }
                CeramicBrickPair type = new CeramicBrickPair(stack2);
                if (type.type != TILE) {
                    return ItemStack.field_190927_a;
                }
                int color2 = type.colorFirst.ordinal();
                if (colors[alt] == -1) {
                    colors[alt] = color2;
                } else if (colors[alt] != color2) {
                    return ItemStack.field_190927_a;
                }
                ++altCounter;
            }
            return new CeramicBrickPair(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), SPLIT).getStack(4);
        }
    }
    ,
    CHEQUERED("cheque"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            if (stacks.size() != 4) {
                return ItemStack.field_190927_a;
            }
            int[] colors = new int[]{-1, -1};
            for (ItemStack stack2 : stacks) {
                if (stack2.func_77973_b() != Item.func_150898_a((Block)ModuleCeramic.ceramicBrick)) {
                    return ItemStack.field_190927_a;
                }
                CeramicBrickPair type2 = new CeramicBrickPair(stack2);
                if (type2.type != SPLIT) {
                    return ItemStack.field_190927_a;
                }
                int color3 = type2.colorFirst.ordinal();
                int color4 = type2.colorSecond.ordinal();
                if (colors[0] == -1) {
                    colors[0] = color3;
                    colors[1] = color4;
                    continue;
                }
                if (colors[0] == color3 && colors[1] == color4) continue;
                return ItemStack.field_190927_a;
            }
            return new CeramicBrickPair(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), CHEQUERED).getStack(4);
        }
    }
    ,
    MIXED("mixed"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            if (stacks.size() != 4) {
                return ItemStack.field_190927_a;
            }
            int[] colors = new int[]{-1, -1};
            for (ItemStack stack2 : stacks) {
                if (stack2.func_77973_b() != Item.func_150898_a((Block)ModuleCeramic.ceramicBrick)) {
                    return ItemStack.field_190927_a;
                }
                CeramicBrickPair type2 = new CeramicBrickPair(stack2);
                if (type2.isTwoColors()) {
                    return ItemStack.field_190927_a;
                }
                int color3 = type2.colorFirst.ordinal();
                if (type2.type == SPLIT) {
                    if (colors[1] != -1) {
                        return ItemStack.field_190927_a;
                    }
                    colors[1] = color3;
                } else {
                    if (type2.type != CHEQUERED) {
                        return ItemStack.field_190927_a;
                    }
                    if (colors[0] == -1) {
                        colors[0] = color3;
                    } else if (colors[0] != color3) {
                        return ItemStack.field_190927_a;
                    }
                }
                int n = type2.colorSecond.ordinal();
            }
            if (colors[0] == -1 || colors[1] == -1) {
                return ItemStack.field_190927_a;
            }
            return new CeramicBrickPair(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), MIXED).getStack(4);
        }
    }
    ,
    VERTICAL_BRICK("verticalbrick"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            return this.getVerticalBrickRecipe(stacks);
        }
    }
    ,
    VERTICAL_STRIPE_BRICK("verticalbrickstripe"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            return this.getVerticalBrickRecipe(stacks);
        }
    }
    ,
    VERTICAL_LARGE_BRICK("verticalbricklarge"){

        @Override
        public ItemStack getRecipe(List<ItemStack> stacks) {
            return this.getVerticalBrickRecipe(stacks);
        }
    };

    public static final CeramicBrickType[] VALUES;
    public String id;
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public TextureAtlasSprite[] sprites;

    private CeramicBrickType(String id) {
        this.id = id;
    }

    public static CeramicBrickType get(int id) {
        return VALUES[id % VALUES.length];
    }

    public boolean canDouble() {
        return this != TILE;
    }

    public abstract ItemStack getRecipe(List<ItemStack> var1);

    protected ItemStack getVerticalBrickRecipe(List<ItemStack> stacks) {
        if (stacks.size() != 1) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack5 = stacks.get(0);
        CeramicBrickPair type = new CeramicBrickPair(stack5);
        if (type.type == LARGE_BRICK) {
            type.type = VERTICAL_LARGE_BRICK;
            return type.getStack(1);
        }
        if (type.type == BRICK) {
            type.type = VERTICAL_BRICK;
            return type.getStack(1);
        }
        if (type.type == STRIPE_BRICK) {
            type.type = VERTICAL_STRIPE_BRICK;
            return type.getStack(1);
        }
        return ItemStack.field_190927_a;
    }

    protected ItemStack getBrickRecipe(CeramicBrickType ceramicType, List<ItemStack> stacks) {
        if (stacks.size() == 1) {
            ItemStack stack5 = stacks.get(0);
            CeramicBrickPair type = new CeramicBrickPair(stack5);
            if (type.type == VERTICAL_BRICK) {
                type.type = ceramicType;
                return type.getStack(1);
            }
            if (type.type == STRIPE_BRICK) {
                type.type = ceramicType;
                return type.getStack(1);
            }
            return ItemStack.field_190927_a;
        }
        if (stacks.size() == 4) {
            int[] colors = new int[]{-1, -1};
            for (int index2 = 0; index2 < stacks.size(); ++index2) {
                int alt2;
                ItemStack stack4 = stacks.get(index2);
                if (stack4.func_77973_b() != Item.func_150898_a((Block)ModuleCeramic.ceramicBrick)) {
                    return ItemStack.field_190927_a;
                }
                CeramicBrickPair type4 = new CeramicBrickPair(stack4);
                if (type4.type != LARGE_BRICK) {
                    return ItemStack.field_190927_a;
                }
                int color5 = type4.colorFirst.ordinal();
                int color6 = type4.colorSecond.ordinal();
                int n = alt2 = index2 != 0 && index2 != 3 ? 1 : 0;
                if (ceramicType == STRIPE_BRICK) {
                    alt2 = 0;
                }
                if (colors[alt2] == -1) {
                    colors[alt2] = color5;
                    colors[1 - alt2] = color6;
                    continue;
                }
                if (colors[alt2] == color5 && colors[1 - alt2] == color6) continue;
                return ItemStack.field_190927_a;
            }
            return new CeramicBrickPair(EnumFlowerColor.get(colors[0]), EnumFlowerColor.get(colors[1]), ceramicType).getStack(4);
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isMortar(ItemStack stack) {
        return stack.func_77973_b() == ModuleCeramic.misc && stack.func_77952_i() == CeramicItems.MORTAR.ordinal();
    }

    public String func_176610_l() {
        return this.id;
    }

    static {
        VALUES = CeramicBrickType.values();
    }
}

