package binnie.genetics.machine.indexer;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventory;
import binnie.core.machines.inventory.SetList;

public abstract class ComponentIndexerInventory<T> extends ComponentInventory implements IInventory {
	public int guiRefreshCounter;
	public List<Integer> sortedInventory;
	int indexerSize;
	List<ItemStack> indexerInventory;
	@Nullable
	T sortingMode;
	boolean needsSorting;

	public ComponentIndexerInventory(final Machine machine) {
		super(machine);
		this.indexerSize = -1;
		this.guiRefreshCounter = 0;
		this.indexerInventory = new SetList<>();
		this.sortedInventory = new SetList<>();
		this.needsSorting = true;
	}

	@Override
	public int func_70302_i_() {
		if (this.indexerSize > 0) {
			return this.indexerSize + 1;
		}
		return this.indexerInventory.size() + 1;
	}

	@Override
	public ItemStack func_70301_a(final int index) {
		if (index >= 0 && index < this.indexerInventory.size()) {
			return this.indexerInventory.get(index);
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public ItemStack func_70298_a(final int index, final int amount) {
		ItemStack stackInSlot = this.func_70301_a(index);
		if (!stackInSlot.func_190926_b()) {
			final ItemStack returnStack = stackInSlot.func_77946_l();
			this.func_70299_a(index, ItemStack.field_190927_a);
			return returnStack;
		}
		return ItemStack.field_190927_a;
	}

	@Override
	public void func_70296_d() {
		super.func_70296_d();
		++this.guiRefreshCounter;
	}

	@Override
	public void func_70299_a(final int index, final ItemStack itemStack) {
		if (index >= 0 && index < this.indexerInventory.size()) {
			this.indexerInventory.set(index, itemStack);
		} else if (!itemStack.func_190926_b()) {
			this.indexerInventory.add(itemStack);
		}
		this.needsSorting = true;
		this.func_70296_d();
	}

	/*@Override
	public ItemStack getStackInSlotOnClosing(final int var1) {
		return null;
	}

	@Override
	public String getInventoryName() {
		return "";
	}*/

	@Override
	public int func_70297_j_() {
		return 64;
	}

	@Override
	public boolean func_70300_a(final EntityPlayer var1) {
		return true;
	}

	/*@Override
	public void openInventory() {
	}

	@Override
	public void closeInventory() {
	}*/

	@Nullable
	public T getMode() {
		return this.sortingMode;
	}

	public void setMode(final T mode) {
		this.sortingMode = mode;
		this.needsSorting = true;
	}

	@Override
	public NBTTagCompound writeToNBT(final NBTTagCompound nbttagcompound2) {
		NBTTagCompound nbttagcompound = super.writeToNBT(nbttagcompound2);
		final NBTTagList indexerNBT = new NBTTagList();
		for (final ItemStack item : this.indexerInventory) {
			final NBTTagCompound itemNBT = new NBTTagCompound();
			item.func_77955_b(itemNBT);
			indexerNBT.func_74742_a(itemNBT);
		}
		nbttagcompound.func_74782_a("indexer", indexerNBT);
		return nbttagcompound;
	}

	@Override
	public void readFromNBT(final NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);
		final NBTTagList indexerNBT = nbttagcompound.func_150295_c("indexer", 10);
		this.indexerInventory.clear();
		for (int i = 0; i < indexerNBT.func_74745_c(); ++i) {
			final NBTTagCompound itemNBT = indexerNBT.func_150305_b(i);
			this.func_70299_a(i, new ItemStack(itemNBT));
		}
		this.needsSorting = true;
		this.func_70296_d();
	}

	public abstract void Sort();
}
