package binnie.extrabees.worldgen;

import java.util.Random;

import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.blocks.BlockExtraBeeHive;
import binnie.extrabees.blocks.type.EnumHiveType;

public class WorldGenHiveRock extends WorldGenHive {

	public WorldGenHiveRock(int rate) {
		super(rate);
	}

	@Override
	public boolean func_180709_b(final World world, final Random random, final BlockPos pos) {
		final IBlockState block = world.func_180495_p(pos);
		if (block.func_177230_c().isAir(block, world, pos)) {
			return false;
		}
		if (block.func_177230_c().isReplaceableOreGen(block, world, pos, BlockStateMatcher.func_177638_a(Blocks.field_150348_b))) {
			world.func_175656_a(pos, ExtraBees.hive.func_176223_P().func_177226_a(BlockExtraBeeHive.hiveType, EnumHiveType.Rock));
			return true;
		}
		return false;
	}
}
