package binnie.extrabees.items;

import javax.annotation.Nullable;
import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import binnie.extrabees.items.types.IndustrialFrame;

public class ItemIndustrialFrame extends Item {

	public ItemIndustrialFrame() {
		this.func_77637_a(CreativeTabs.field_78026_f);
		this.func_77656_e(400);
		this.func_77625_d(1);
		this.func_77655_b("industrialFrame");
	}

	@Nullable
	public static IndustrialFrame getFrame(final ItemStack stack) {
		NBTTagCompound tagCompound = stack.func_77978_p();
		if (tagCompound == null || !tagCompound.func_74764_b("frame")) {
			return null;
		}
		return IndustrialFrame.values()[tagCompound.func_74762_e("frame")];
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_150895_a(final Item itemIn, final CreativeTabs tab, final NonNullList<ItemStack> subItems) {
		for (final IndustrialFrame frame : IndustrialFrame.values()) {
			final ItemStack stack = new ItemStack(this);
			final NBTTagCompound nbt = new NBTTagCompound();
			nbt.func_74768_a("frame", frame.ordinal());
			stack.func_77982_d(nbt);
			subItems.add(stack);
		}
	}

	@Override
	@SideOnly(Side.CLIENT)
	public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
		super.func_77624_a(stack, playerIn, tooltip, advanced);
		final IndustrialFrame frame = getFrame(stack);
		if (frame == null) {
			tooltip.add("Invalid Contents");
		} else {
			tooltip.add(frame.getName());
		}
	}

	@Override
	public String func_77653_i(final ItemStack itemStack) {
		return "Industrial Frame";
	}
}
