package binnie.extrabees.client.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IContainerListener;

import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.SlotItemHandler;

import binnie.extrabees.alveary.AlvearyLogicStimulator;
import binnie.extrabees.alveary.EnumAlvearyLogicType;

public class ContainerStimulator extends AbstractAlvearyContainer {

	private final AlvearyLogicStimulator logic;
	private final IEnergyStorage storage;
	protected int power, maxPower;

	public ContainerStimulator(EntityPlayer player, AlvearyLogicStimulator logic) {
		super(player, logic.getInventory(), EnumAlvearyLogicType.STIMULATOR, DEFAULT_DIMENSION);
		this.storage = logic.getEnergyStorage();
		this.logic = logic;
		this.maxPower = storage.getMaxEnergyStored();
		if (!player.field_70170_p.field_72995_K) {
			logic.onContainerOpened(this);
		}
	}

	@Override
	protected void setupContainer() {
		offset = -21;
		addPlayerInventory();
		title = "Stimulator";
		func_75146_a(new SlotItemHandler(inv, 0, 44, 37));
	}

	public void checkPower() {
		if (power != storage.getEnergyStored()) {
			for (IContainerListener listener : field_75149_d) {
				listener.func_71112_a(this, 9, power = storage.getEnergyStored());
			}
		}
	}

	@Override
	public void func_75134_a(EntityPlayer playerIn) {
		super.func_75134_a(playerIn);
		logic.onGuiClosed(this);
	}

	@Override
	public void func_75137_b(int id, int data) {
		if (id == 9) {
			power = data;
		}
	}
}
