/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees;

import binnie.core.BinnieCore;
import binnie.core.gui.IBinnieGUID;
import binnie.core.machines.errors.ErrorStateRegistry;
import binnie.core.network.BinniePacketHandler;
import binnie.core.proxy.IProxyCore;
import binnie.extratrees.block.ModuleBlocks;
import binnie.extratrees.config.ConfigurationMain;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreesErrorCode;
import binnie.extratrees.proxy.Proxy;
import binnie.modules.BlankModuleContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="extratrees", name="Binnie's Extra Trees", dependencies="required-after:binniecore", acceptedMinecraftVersions="[1.11.2]")
public class ExtraTrees
extends BlankModuleContainer {
    @Mod.Instance(value="extratrees")
    public static ExtraTrees instance;
    @SidedProxy(clientSide="binnie.extratrees.proxy.ProxyClient", serverSide="binnie.extratrees.proxy.ProxyServer")
    public static Proxy proxy;

    public ExtraTrees() {
        MinecraftForge.EVENT_BUS.register(ModuleBlocks.class);
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        super.preInit(evt);
        for (ExtraTreesErrorCode errorCode : ExtraTreesErrorCode.values()) {
            ErrorStateRegistry.registerErrorState(errorCode);
        }
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        super.postInit(evt);
    }

    @Override
    protected void registerModules() {
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return ExtraTreesGUID.values();
    }

    @Override
    public Class<?>[] getConfigs() {
        return new Class[]{ConfigurationMain.class};
    }

    @Override
    public String getChannel() {
        return "ET";
    }

    @Override
    public IProxyCore getProxy() {
        return proxy;
    }

    @Override
    public String getModID() {
        return "extratrees";
    }

    @Override
    protected Class<? extends BinniePacketHandler> getPacketHandler() {
        return PacketHandler.class;
    }

    @Override
    public boolean isAvailable() {
        return BinnieCore.isExtraTreesActive();
    }

    public static class PacketHandler
    extends BinniePacketHandler {
        public PacketHandler() {
            super(instance);
        }
    }
}

