/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.ceramic.brick;

import binnie.botany.ceramic.brick.CeramicBrickType;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.modules.ModuleCeramic;
import binnie.core.util.I18N;
import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CeramicBrickPair {
    public static final CeramicBrickPair EMPTY = new CeramicBrickPair(EnumFlowerColor.DarkSeaGreen, EnumFlowerColor.DarkSeaGreen, CeramicBrickType.TILE);
    public final EnumFlowerColor colorFirst;
    public final EnumFlowerColor colorSecond;
    public CeramicBrickType type;
    public int ordinal;

    public CeramicBrickPair(EnumFlowerColor colorFirst, EnumFlowerColor colorSecond, CeramicBrickType type) {
        this.colorFirst = colorFirst;
        this.colorSecond = colorSecond;
        this.type = type;
        this.ordinal = colorFirst.ordinal() + colorSecond.ordinal() * 256 + type.ordinal() * 256 * 256;
    }

    public CeramicBrickPair(ItemStack stack) {
        this(CeramicBrickPair.getId(stack));
    }

    public CeramicBrickPair(int id) {
        this.colorFirst = EnumFlowerColor.get(id & 0xFF);
        this.colorSecond = EnumFlowerColor.get(id >> 8 & 0xFF);
        this.type = CeramicBrickType.get(id >> 16 & 0xFF);
    }

    public boolean isTwoColors() {
        return this.type.canDouble() && this.colorSecond != this.colorFirst;
    }

    public static int getId(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return EMPTY.ordinal();
        }
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        return nbtTagCompound.func_74762_e("id");
    }

    public ItemStack getStack(int i) {
        ItemStack stack = new ItemStack((Block)ModuleCeramic.ceramicBrick, i);
        stack.func_77983_a("id", (NBTBase)new NBTTagInt(this.ordinal()));
        return stack;
    }

    public String getName() {
        String name = this.colorFirst.getFlowerColorAllele().getColorName();
        if (this.type.canDouble() && this.colorSecond != this.colorFirst) {
            name = name + " & " + this.colorSecond.getFlowerColorAllele().getColorName();
        }
        return I18N.localise("botany.ceramic.type." + this.type.id + ".name", name);
    }

    public int ordinal() {
        return this.ordinal;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite(int pass) {
        TextureAtlasSprite[] sprites = this.type.sprites;
        Preconditions.checkState((sprites != null ? 1 : 0) != 0, (Object)"Sprites have not been registered.");
        return sprites[pass];
    }

    public int hashCode() {
        return Integer.hashCode(this.type.ordinal());
    }

    public boolean equals(Object obj) {
        return obj instanceof CeramicBrickPair && ((CeramicBrickPair)obj).type == this.type;
    }
}

