/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.blocks;

import binnie.botany.CreativeTabBotany;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.core.util.I18N;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.blocks.IColoredBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStainedGlass
extends Block
implements IBlockMetadata,
IColoredBlock,
IItemModelRegister {
    public BlockStainedGlass() {
        super(Material.field_151592_s);
        this.func_149647_a(CreativeTabBotany.instance);
        this.setRegistryName("stained");
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.3f);
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (EnumFlowerColor color : EnumFlowerColor.values()) {
            manager.registerItemModel(item, color.getFlowerColorAllele().getID());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return block != this;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0 && te instanceof TileEntityMetadata) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            TileEntityMetadata tile = (TileEntityMetadata)te;
            int damage = this.getDroppedMeta(state, tile.getTileMetadata());
            ItemStack itemstack = TileEntityMetadata.getItemStack(this, damage);
            if (!itemstack.func_190926_b()) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                BlockStainedGlass.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    @Override
    public int getPlacedMeta(ItemStack stack, World world, BlockPos pos, EnumFacing clickedBlock) {
        return TileEntityMetadata.getItemDamage(stack);
    }

    @Override
    public int getDroppedMeta(IBlockState state, int tileMetadata) {
        return tileMetadata;
    }

    @Override
    public String getDisplayName(ItemStack itemStack) {
        EnumFlowerColor color = EnumFlowerColor.get(TileEntityMetadata.getItemDamage(itemStack));
        return I18N.localise("botany.pigmented.glass.name", color.getDisplayName());
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> itemList) {
        for (EnumFlowerColor color : EnumFlowerColor.values()) {
            itemList.add((Object)TileEntityMetadata.getItemStack(this, color.ordinal()));
        }
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return BlockMetadata.getPickBlock(world, pos);
    }

    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (worldIn == null || pos == null) {
            return 0;
        }
        EnumFlowerColor color = EnumFlowerColor.get(TileEntityMetadata.getTileMetadata(worldIn, pos));
        return color.getFlowerColorAllele().getColor(false);
    }
}

