/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.blocks;

import binnie.botany.CreativeTabBotany;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.tile.TileCeramic;
import binnie.core.BinnieCore;
import binnie.core.util.TileUtil;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.blocks.IColoredBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCeramic
extends Block
implements IColoredBlock,
IItemModelRegister {
    public BlockCeramic() {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.setRegistryName("ceramic");
        this.func_149647_a(CreativeTabBotany.instance);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        for (EnumFlowerColor c : EnumFlowerColor.values()) {
            manager.registerItemModel(item, c.ordinal());
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, @Nullable EntityPlayer player, boolean willHarvest) {
        boolean hasBeenBroken;
        List<Object> drops = new ArrayList();
        TileCeramic ceramic = TileUtil.getTile((IBlockAccess)world, pos, TileCeramic.class);
        if (ceramic != null) {
            drops = Collections.singletonList(ceramic.getStack());
        }
        if ((hasBeenBroken = world.func_175698_g(pos)) && BinnieCore.getBinnieProxy().isSimulating(world) && drops.size() > 0 && (player == null || !player.field_71075_bZ.field_75098_d)) {
            for (ItemStack itemStack : drops) {
                BlockCeramic.func_180635_a((World)world, (BlockPos)pos, (ItemStack)itemStack);
            }
        }
        return hasBeenBroken;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCeramic();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileCeramic ceramic = TileUtil.getTile((IBlockAccess)worldIn, pos, TileCeramic.class);
        if (ceramic != null) {
            ceramic.setColor(EnumFlowerColor.VALUES[stack.func_77952_i()]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> itemList) {
        for (EnumFlowerColor c : EnumFlowerColor.values()) {
            itemList.add((Object)new ItemStack(item, 1, c.getFlowerColorAllele().getID()));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileCeramic ceramic = TileUtil.getTile((IBlockAccess)world, pos, TileCeramic.class);
        if (ceramic != null) {
            return ceramic.getStack();
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos, int tintIndex) {
        TileCeramic ceramic;
        if (world != null && pos != null && (ceramic = TileUtil.getTile(world, pos, TileCeramic.class)) != null) {
            return ceramic.getColor().getFlowerColorAllele().getColor(false);
        }
        return EnumFlowerColor.get(0).getFlowerColorAllele().getColor(false);
    }
}

