package binnie.extrabees.proxy;

import com.google.common.collect.ImmutableList;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;

import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;

import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import forestry.core.models.BlankModel;
import forestry.core.models.ModelManager;

import binnie.extrabees.ExtraBees;
import binnie.extrabees.items.IItemModelProvider;
import binnie.extrabees.utils.ExtraBeesResourceLocation;

public class ExtraBeesClientProxy extends ExtraBeesCommonProxy {
	
	private static final ModelManager modelManager = ModelManager.getInstance();
	
	private static IBakedModel bakeModelFor(Block block) {
		return new BlankModel() {

			@Override
			protected ItemOverrideList createOverrides() {
				return new ItemOverrideList(ImmutableList.of()) {

					@Override
					@SuppressWarnings("deprecation")
					public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
						return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(block.func_176203_a(stack.func_77960_j()));
					}
				};
			}
		};
	}
	
	@Override
	public Item registerItem(Item item) {
		modelManager.registerItemClient(item);
		if(item instanceof IItemModelProvider){
			((IItemModelProvider) item).registerModel(item);
		}
		return super.registerItem(item);
	}
	
	@Override
	public Block registerBlock(Block block) {
		modelManager.registerBlockClient(block);
		return super.registerBlock(block);
	}
	
	@Override
	@SuppressWarnings("all")
	public void registerModel(@Nonnull Item item, int meta) {
		ModelLoader.setCustomModelResourceLocation(item, meta, new ModelResourceLocation(item.getRegistryName(), "inventory"));
	}
	
	@SubscribeEvent
	public void onModelsBaked(ModelBakeEvent event) {
		IRegistry<ModelResourceLocation, IBakedModel> registry = event.getModelRegistry();
		registerItemBlockLink(new ExtraBeesResourceLocation("alveary"), ExtraBees.alveary, registry);
		registerItemBlockLink(new ExtraBeesResourceLocation("ectoplasm"), ExtraBees.ectoplasm, registry);
		registerItemBlockLink(new ExtraBeesResourceLocation("hive"), ExtraBees.hive, registry);
	}

	private void registerItemBlockLink(ResourceLocation item, Block block, IRegistry<ModelResourceLocation, IBakedModel> registry) {
		registry.func_82595_a(new ModelResourceLocation(item, "inventory"), bakeModelFor(block));
	}
}
