package binnie.core.models;

import javax.annotation.Nullable;
import java.util.LinkedList;
import java.util.List;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class DoublePassBakedModel implements IBakedModel {
	private static final int c = DefaultVertexFormats.field_176599_b.func_177340_e() / 4;
	private static final int v = DefaultVertexFormats.field_176599_b.func_177338_f() / 4;
	private IBakedModel mainModel;
	private int primaryColor = 0xFF000000;
	private int secondaryColor = 0xFF000000;

	/**
	 * It colorizes the quads according to tintindex, which is defined in the json file.
	 *
	 * @param mainModel      old model
	 * @param primaryColor   color for tintindex 0
	 * @param secondaryColor color for tintindex 1
	 */
	public DoublePassBakedModel(IBakedModel mainModel, int primaryColor, int secondaryColor) {
		this.mainModel = mainModel;
		this.primaryColor |= (Integer.reverseBytes(primaryColor) >> 8);
		this.secondaryColor |= (Integer.reverseBytes(secondaryColor) >> 8);
	}

	@Override
	public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
		List<BakedQuad> quads = mainModel.func_188616_a(state, side, rand);
		List<BakedQuad> recolored = new LinkedList<>();
		quads.forEach(quad -> {
			if (quad.func_178212_b()) {
				if (quad.func_178211_c() == 0)
					recolored.add(recolorQuad(quad, primaryColor));
				else
					recolored.add(recolorQuad(quad, secondaryColor));
			} else {
				recolored.add(quad);
			}
		});

		return recolored;
	}

	public BakedQuad recolorQuad(BakedQuad quad, int color) {
		int[] vertexData = quad.func_178209_a();
		for (int i = 0; i < 4; i++) {
			vertexData[v * i + c] = color;
		}
		return quad;
	}

	@Override
	public boolean func_177555_b() {
		return mainModel.func_177555_b();
	}

	@Override
	public boolean func_177556_c() {
		return mainModel.func_177556_c();
	}

	@Override
	public boolean func_188618_c() {
		return mainModel.func_188618_c();
	}

	@Override
	public TextureAtlasSprite func_177554_e() {
		return mainModel.func_177554_e();
	}

	@Override
	public ItemCameraTransforms func_177552_f() {
		return mainModel.func_177552_f();
	}

	@Override
	public ItemOverrideList func_188617_f() {
		return mainModel.func_188617_f();
	}
}
